/*
 * Decompiled with CFR 0.152.
 */
package jadx.zip.fallback;

import jadx.zip.IZipEntry;
import jadx.zip.IZipParser;
import jadx.zip.ZipContent;
import jadx.zip.ZipReaderOptions;
import jadx.zip.fallback.FallbackZipEntry;
import jadx.zip.io.LimitedInputStream;
import jadx.zip.security.IJadxZipSecurity;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackZipParser
implements IZipParser {
    private static final Logger LOG = LoggerFactory.getLogger(FallbackZipParser.class);
    private final File file;
    private final IJadxZipSecurity zipSecurity;
    private final boolean useLimitedDataStream;
    private ZipFile zipFile;

    public FallbackZipParser(File file2, ZipReaderOptions options) {
        this.file = file2;
        this.zipSecurity = options.getZipSecurity();
        this.useLimitedDataStream = this.zipSecurity.useLimitedDataStream();
    }

    @Override
    public ZipContent open() throws IOException {
        this.zipFile = new ZipFile(this.file);
        int maxEntriesCount = this.zipSecurity.getMaxEntriesCount();
        if (maxEntriesCount == -1) {
            maxEntriesCount = Integer.MAX_VALUE;
        }
        ArrayList<IZipEntry> list2 = new ArrayList<IZipEntry>();
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            FallbackZipEntry zipEntry = new FallbackZipEntry(this, entries.nextElement());
            if (!this.isValidEntry(zipEntry)) continue;
            list2.add(zipEntry);
            if (list2.size() <= maxEntriesCount) continue;
            throw new IllegalStateException("Max entries count limit exceeded: " + list2.size());
        }
        return new ZipContent(this, list2);
    }

    private boolean isValidEntry(IZipEntry zipEntry) {
        boolean validEntry = this.zipSecurity.isValidEntry(zipEntry);
        if (!validEntry) {
            LOG.warn("Zip entry '{}' is invalid and excluded from processing", (Object)zipEntry);
        }
        return validEntry;
    }

    public byte[] getBytes(FallbackZipEntry entry) {
        byte[] byArray;
        block8: {
            InputStream is4 = this.getEntryStream(entry);
            try {
                byArray = is4.readAllBytes();
                if (is4 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is4 != null) {
                        try {
                            is4.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e15) {
                    throw new RuntimeException("Failed to read bytes for entry: " + entry.getName(), e15);
                }
            }
            is4.close();
        }
        return byArray;
    }

    public InputStream getInputStream(FallbackZipEntry entry) {
        try {
            return this.getEntryStream(entry);
        }
        catch (Exception e15) {
            throw new RuntimeException("Failed to open input stream for entry: " + entry.getName(), e15);
        }
    }

    private InputStream getEntryStream(FallbackZipEntry entry) throws IOException {
        InputStream entryStream = this.zipFile.getInputStream(entry.getZipEntry());
        InputStream stream = this.useLimitedDataStream ? new LimitedInputStream(entryStream, entry.getUncompressedSize()) : entryStream;
        return new BufferedInputStream(stream);
    }

    public File getZipFile() {
        return this.file;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.zipFile != null) {
                this.zipFile.close();
            }
        }
        finally {
            this.zipFile = null;
        }
    }
}

