/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.tools.resolvers.github;

import com.google.gson.reflect.TypeToken;
import jadx.core.utils.GsonUtils;
import jadx.core.utils.files.FileUtils;
import jadx.plugins.tools.resolvers.github.LocationInfo;
import jadx.plugins.tools.resolvers.github.data.Release;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;

public class GithubTools {
    private static final GithubTools GITHUB_INSTANCE = new GithubTools("https://api.github.com");
    private static final Type RELEASE_TYPE = new TypeToken<Release>(){}.getType();
    private static final Type RELEASE_LIST_TYPE = new TypeToken<List<Release>>(){}.getType();
    private final String baseUrl;

    public static Release fetchRelease(LocationInfo info) {
        return GITHUB_INSTANCE.getRelease(info);
    }

    public static List<Release> fetchReleases(LocationInfo info, int page, int perPage) {
        return GITHUB_INSTANCE.getReleases(info, page, perPage);
    }

    GithubTools(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    Release getRelease(LocationInfo info) {
        String projectUrl = this.baseUrl + "/repos/" + info.getOwner() + "/" + info.getProject();
        String version = info.getVersion();
        if (version == null) {
            return (Release)GithubTools.get(projectUrl + "/releases/latest", RELEASE_TYPE);
        }
        List<Release> releases = GithubTools.fetchReleases(info, 1, 50);
        return releases.stream().filter(r15 -> r15.getName().equals(version)).findFirst().orElseThrow(() -> new RuntimeException("Release with version: " + version + " not found. Available versions: " + releases.stream().map(Release::getName).collect(Collectors.joining(", "))));
    }

    List<Release> getReleases(LocationInfo info, int page, int perPage) {
        String projectUrl = this.baseUrl + "/repos/" + info.getOwner() + "/" + info.getProject();
        String requestUrl = projectUrl + "/releases?page=" + page + "&per_page=" + perPage;
        return (List)GithubTools.get(requestUrl, RELEASE_LIST_TYPE);
    }

    /*
     * Loose catch block
     */
    private static <T> T get(String url, Type type) {
        HttpURLConnection con = null;
        try {
            try {
                con = (HttpURLConnection)URI.create(url).toURL().openConnection();
                con.setRequestMethod("GET");
                con.setInstanceFollowRedirects(true);
                int code = con.getResponseCode();
                if (code != 200) {
                    throw new RuntimeException(GithubTools.buildErrorDetails(con, url));
                }
            }
            catch (IOException e15) {
                throw new RuntimeException("Request failed, url: " + url, e15);
            }
            InputStreamReader reader = new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8);
            Object t15 = GsonUtils.buildGson().fromJson((Reader)reader, type);
            ((Reader)reader).close();
            return t15;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e16) {
                        throw new RuntimeException("Failed to parse response, url: " + url, e16);
                    }
                }
            }
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    private static String buildErrorDetails(HttpURLConnection con, String url) throws IOException {
        String value;
        Object shortMsg = con.getResponseMessage();
        String remainRateLimit = con.getHeaderField("X-RateLimit-Remaining");
        if ("0".equals(remainRateLimit)) {
            String resetTimeMs = con.getHeaderField("X-RateLimit-Reset");
            String timeStr = resetTimeMs != null ? "after " + String.valueOf(Instant.ofEpochSecond(Long.parseLong(resetTimeMs))) : "in one hour";
            shortMsg = (String)shortMsg + " (rate limit reached, try again " + timeStr + ")";
        }
        StringBuilder headers = new StringBuilder();
        int i15 = 0;
        while ((value = con.getHeaderField(i15)) != null) {
            String key = con.getHeaderFieldKey(i15);
            if (key != null) {
                headers.append('\n').append(key).append(": ").append(value);
            }
            ++i15;
        }
        String responseStr = GithubTools.getResponseString(con);
        return "Request failed: " + con.getResponseCode() + " " + (String)shortMsg + "\nURL: " + url + "\nHeaders:" + String.valueOf(headers) + (String)(responseStr.isEmpty() ? "" : "\nresponse:\n" + responseStr);
    }

    private static String getResponseString(HttpURLConnection con) {
        String string;
        block8: {
            InputStream in4 = con.getInputStream();
            try {
                string = new String(FileUtils.streamToByteArray(in4), StandardCharsets.UTF_8);
                if (in4 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in4 != null) {
                        try {
                            in4.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e15) {
                    return "";
                }
            }
            in4.close();
        }
        return string;
    }
}

