/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.tools;

import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.loader.JadxPluginLoader;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import jadx.plugins.tools.JadxPluginsTools;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxExternalPluginsLoader
implements JadxPluginLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JadxExternalPluginsLoader.class);
    public static final String JADX_PLUGIN_CLASSLOADER_PREFIX = "jadx-plugin:";
    private final List<URLClassLoader> classLoaders = new ArrayList<URLClassLoader>();

    @Override
    public List<JadxPlugin> load() {
        this.close();
        long start = System.currentTimeMillis();
        HashMap<String, JadxPlugin> map = new HashMap<String, JadxPlugin>();
        this.loadFromClsLoader(map, JadxExternalPluginsLoader.thisClassLoader());
        this.loadInstalledPlugins(map);
        ArrayList<JadxPlugin> list2 = new ArrayList<JadxPlugin>(map.size());
        list2.addAll(map.values());
        list2.sort(Comparator.comparing(p15 -> p15.getClass().getSimpleName()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Collected {} plugins in {}ms", (Object)list2.size(), (Object)(System.currentTimeMillis() - start));
        }
        return list2;
    }

    public JadxPlugin loadFromPath(Path pluginPath) {
        HashMap<String, JadxPlugin> map = new HashMap<String, JadxPlugin>();
        this.loadFromPath(map, pluginPath);
        int loaded = map.size();
        if (loaded == 0) {
            throw new JadxRuntimeException("No plugin found in jar: " + String.valueOf(pluginPath));
        }
        if (loaded > 1) {
            String plugins = map.values().stream().map(p15 -> p15.getPluginInfo().getPluginId()).collect(Collectors.joining(", "));
            throw new JadxRuntimeException("Expect only one plugin per jar: " + String.valueOf(pluginPath) + ", but found: " + loaded + " - " + plugins);
        }
        return (JadxPlugin)Utils.first(map.values());
    }

    private void loadFromClsLoader(Map<String, JadxPlugin> map, ClassLoader classLoader) {
        ServiceLoader<JadxPlugin> serviceLoader = ServiceLoader.load(JadxPlugin.class, classLoader);
        for (ServiceLoader.Provider provider : serviceLoader.stream().collect(Collectors.toList())) {
            Class pluginClass = provider.type();
            String clsName = pluginClass.getName();
            if (map.containsKey(clsName) || pluginClass.getClassLoader() != classLoader) continue;
            map.put(clsName, (JadxPlugin)provider.get());
        }
    }

    private void loadInstalledPlugins(Map<String, JadxPlugin> map) {
        List<Path> paths = JadxPluginsTools.getInstance().getEnabledPluginPaths();
        for (Path pluginPath : paths) {
            this.loadFromPath(map, pluginPath);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadFromPath(Map<String, JadxPlugin> map, Path pluginPath) {
        try {
            URL[] urls;
            if (Files.isDirectory(pluginPath, new LinkOption[0])) {
                urls = (URL[])FileUtils.listFiles(pluginPath, file2 -> FileUtils.hasExtension(file2, ".jar")).stream().map(JadxExternalPluginsLoader::toURL).toArray(URL[]::new);
                if (urls.length == 0) {
                    throw new JadxRuntimeException("No jar files found in plugin directory");
                }
            } else {
                if (!Files.isRegularFile(pluginPath, new LinkOption[0])) throw new JadxRuntimeException("Plugin file not found");
                if (!FileUtils.hasExtension(pluginPath, ".jar")) throw new JadxRuntimeException("Unexpected plugin file format");
                urls = new URL[]{JadxExternalPluginsLoader.toURL(pluginPath)};
            }
            String clsLoaderName = JADX_PLUGIN_CLASSLOADER_PREFIX + String.valueOf(pluginPath.getFileName());
            URLClassLoader pluginClsLoader = new URLClassLoader(clsLoaderName, urls, JadxExternalPluginsLoader.thisClassLoader());
            this.classLoaders.add(pluginClsLoader);
            this.loadFromClsLoader(map, pluginClsLoader);
            return;
        }
        catch (Exception e15) {
            throw new JadxRuntimeException("Failed to load plugins from: " + String.valueOf(pluginPath), e15);
        }
    }

    private static URL toURL(Path pluginPath) {
        try {
            return pluginPath.toUri().toURL();
        }
        catch (MalformedURLException e15) {
            throw new RuntimeException(e15);
        }
    }

    private static ClassLoader thisClassLoader() {
        return JadxExternalPluginsLoader.class.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            for (URLClassLoader classLoader : this.classLoaders) {
                try {
                    classLoader.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            this.classLoaders.clear();
        }
    }
}

