/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.attributes.types;

import jadx.api.plugins.input.data.annotations.AnnotationVisibility;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.api.plugins.input.data.attributes.types.AnnotationMethodParamsAttr;
import jadx.api.plugins.utils.Utils;
import jadx.plugins.input.java.data.attributes.IJavaAttribute;
import jadx.plugins.input.java.data.attributes.IJavaAttributeReader;
import jadx.plugins.input.java.data.attributes.JavaAttrStorage;
import jadx.plugins.input.java.data.attributes.JavaAttrType;
import jadx.plugins.input.java.data.attributes.types.JavaAnnotationsAttr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JavaParamAnnsAttr
implements IJavaAttribute {
    private final List<List<IAnnotation>> list;

    public JavaParamAnnsAttr(List<List<IAnnotation>> list2) {
        this.list = list2;
    }

    public List<List<IAnnotation>> getList() {
        return this.list;
    }

    public static IJavaAttributeReader reader(AnnotationVisibility visibility2) {
        return (clsData, reader) -> {
            int len = reader.readU1();
            ArrayList<List<IAnnotation>> list2 = new ArrayList<List<IAnnotation>>(len);
            for (int i15 = 0; i15 < len; ++i15) {
                list2.add(JavaAnnotationsAttr.readAnnotationsList(visibility2, clsData, reader));
            }
            return new JavaParamAnnsAttr(list2);
        };
    }

    public static AnnotationMethodParamsAttr merge(JavaAttrStorage storage) {
        JavaParamAnnsAttr runtimeAnnAttr = storage.get(JavaAttrType.RUNTIME_PARAMETER_ANNOTATIONS);
        JavaParamAnnsAttr buildAnnAttr = storage.get(JavaAttrType.BUILD_PARAMETER_ANNOTATIONS);
        if (runtimeAnnAttr == null && buildAnnAttr == null) {
            return null;
        }
        if (buildAnnAttr == null) {
            return AnnotationMethodParamsAttr.pack(runtimeAnnAttr.getList());
        }
        if (runtimeAnnAttr == null) {
            return AnnotationMethodParamsAttr.pack(buildAnnAttr.getList());
        }
        return AnnotationMethodParamsAttr.pack(JavaParamAnnsAttr.mergeParamLists(runtimeAnnAttr.getList(), buildAnnAttr.getList()));
    }

    private static List<List<IAnnotation>> mergeParamLists(List<List<IAnnotation>> first, List<List<IAnnotation>> second) {
        int firstSize = first.size();
        int secondSize = second.size();
        int size = Math.max(firstSize, secondSize);
        ArrayList<List<IAnnotation>> result = new ArrayList<List<IAnnotation>>(size);
        for (int i15 = 0; i15 < size; ++i15) {
            List firstList = i15 < firstSize ? first.get(i15) : Collections.emptyList();
            List secondList = i15 < secondSize ? second.get(i15) : Collections.emptyList();
            result.add(Utils.concat(firstList, secondList));
        }
        return result;
    }
}

