/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java;

import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.JadxPluginContext;
import jadx.api.plugins.JadxPluginInfo;
import jadx.api.plugins.input.ICodeLoader;
import jadx.api.plugins.input.data.impl.EmptyCodeLoader;
import jadx.plugins.input.java.JavaClassReader;
import jadx.plugins.input.java.JavaInputLoader;
import jadx.plugins.input.java.JavaLoadResult;
import jadx.plugins.input.java.utils.JavaClassParseException;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class JavaInputPlugin
implements JadxPlugin {
    @Override
    public JadxPluginInfo getPluginInfo() {
        return new JadxPluginInfo("java-input", "Java Input", "Load .class and .jar files");
    }

    @Override
    public void init(JadxPluginContext context) {
        context.addCodeInput(inputFiles -> {
            JavaInputLoader loader = new JavaInputLoader(context.getZipReader(), context.files().getPluginTempDir());
            List<JavaClassReader> readers = loader.collectFiles(inputFiles);
            if (readers.isEmpty()) {
                return EmptyCodeLoader.INSTANCE;
            }
            return new JavaLoadResult(readers, null);
        });
    }

    public static ICodeLoader loadClassFiles(List<Path> inputFiles) {
        return JavaInputPlugin.loadClassFiles(inputFiles, null);
    }

    public static ICodeLoader loadClassFiles(List<Path> inputFiles, @Nullable Closeable closeable) {
        List<JavaClassReader> readers = new JavaInputLoader().collectFiles(inputFiles);
        if (readers.isEmpty()) {
            return EmptyCodeLoader.INSTANCE;
        }
        return new JavaLoadResult(readers, closeable);
    }

    public static ICodeLoader load(Function<JavaInputLoader, List<JavaClassReader>> loader) {
        return JavaInputPlugin.wrapClassReaders(loader.apply(new JavaInputLoader()));
    }

    public static ICodeLoader loadFromInputStream(InputStream in4, String fileName) {
        try {
            return JavaInputPlugin.wrapClassReaders(new JavaInputLoader().loadInputStream(in4, fileName));
        }
        catch (Exception e15) {
            throw new JavaClassParseException("Failed to read input stream", e15);
        }
    }

    public static ICodeLoader loadSingleClass(byte[] content, String fileName) {
        JavaClassReader reader = new JavaInputLoader().loadClass(content, fileName);
        return new JavaLoadResult(Collections.singletonList(reader));
    }

    public static ICodeLoader wrapClassReaders(List<JavaClassReader> readers) {
        if (readers.isEmpty()) {
            return EmptyCodeLoader.INSTANCE;
        }
        return new JavaLoadResult(readers);
    }
}

