/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java;

import jadx.api.plugins.utils.CommonFileUtils;
import jadx.core.plugins.files.TempFilesGetter;
import jadx.core.utils.files.FileUtils;
import jadx.plugins.input.java.JavaClassReader;
import jadx.zip.IZipEntry;
import jadx.zip.ZipContent;
import jadx.zip.ZipReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaInputLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JavaInputLoader.class);
    private static final int MAX_MAGIC_SIZE = 4;
    private static final byte[] JAVA_CLASS_FILE_MAGIC = new byte[]{-54, -2, -70, -66};
    private static final byte[] ZIP_FILE_MAGIC = new byte[]{80, 75, 3, 4};
    private final ZipReader zipReader;
    private final Path tempPath;
    private int classUniqId = 1;

    public JavaInputLoader(ZipReader zipReader, Path tempPath) {
        this.zipReader = zipReader;
        this.tempPath = tempPath;
    }

    @Deprecated
    public JavaInputLoader() {
        this(new ZipReader(), TempFilesGetter.INSTANCE.getTempDir());
    }

    public List<JavaClassReader> collectFiles(List<Path> inputFiles) {
        return inputFiles.stream().map(Path::toFile).map(this::loadFromFile).filter(list2 -> !list2.isEmpty()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<JavaClassReader> loadInputStream(InputStream in4, String name) throws IOException {
        return this.loadReader(in4, name, null, null);
    }

    public JavaClassReader loadClass(byte[] content, String fileName) {
        return new JavaClassReader(this.getNextUniqId(), fileName, content);
    }

    private List<JavaClassReader> loadFromFile(File file2) {
        List<JavaClassReader> list2;
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file2));
        try {
            list2 = this.loadReader(inputStream, file2.getName(), file2, null);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e15) {
                LOG.error("File open error: {}", (Object)file2.getAbsolutePath(), (Object)e15);
                return Collections.emptyList();
            }
        }
        ((InputStream)inputStream).close();
        return list2;
    }

    private List<JavaClassReader> loadReader(InputStream in4, String name, @Nullable File file2, @Nullable String parentFileName) throws IOException {
        byte[] magic = new byte[4];
        if (in4.read(magic) != magic.length) {
            return Collections.emptyList();
        }
        if (JavaInputLoader.isStartWithBytes(magic, JAVA_CLASS_FILE_MAGIC) || name.endsWith(".class")) {
            byte[] data = CommonFileUtils.loadBytes(magic, in4);
            String source = JavaInputLoader.concatSource(parentFileName, name);
            JavaClassReader reader = new JavaClassReader(this.getNextUniqId(), source, data);
            return Collections.singletonList(reader);
        }
        if (JavaInputLoader.isStartWithBytes(magic, ZIP_FILE_MAGIC) || CommonFileUtils.isZipFileExt(name)) {
            if (file2 != null) {
                return this.collectFromZip(file2, name);
            }
            File zipFile = CommonFileUtils.saveToTempFile(magic, in4, ".zip").toFile();
            List<JavaClassReader> readers = this.collectFromZip(zipFile, JavaInputLoader.concatSource(parentFileName, name));
            CommonFileUtils.safeDeleteFile(zipFile);
            return readers;
        }
        return Collections.emptyList();
    }

    private List<JavaClassReader> loadReaderFromZipEntry(byte[] content, String name, String parentFileName) throws IOException {
        if (JavaInputLoader.isStartWithBytes(content, JAVA_CLASS_FILE_MAGIC) || name.endsWith(".class")) {
            String source = JavaInputLoader.concatSource(parentFileName, name);
            JavaClassReader reader = new JavaClassReader(this.getNextUniqId(), source, content);
            return Collections.singletonList(reader);
        }
        if (JavaInputLoader.isStartWithBytes(content, ZIP_FILE_MAGIC) || CommonFileUtils.isZipFileExt(name)) {
            Path tempZip = Files.createTempFile(this.tempPath, "temp", ".zip", new FileAttribute[0]);
            FileUtils.writeFile(tempZip, content);
            File zipFile = tempZip.toFile();
            List<JavaClassReader> readers = this.collectFromZip(zipFile, JavaInputLoader.concatSource(parentFileName, name));
            CommonFileUtils.safeDeleteFile(zipFile);
            return readers;
        }
        return Collections.emptyList();
    }

    private static String concatSource(@Nullable String parentFileName, String name) {
        if (parentFileName == null) {
            return name;
        }
        return parentFileName + ":" + name;
    }

    private List<JavaClassReader> collectFromZip(File file2, String name) {
        ArrayList<JavaClassReader> result = new ArrayList<JavaClassReader>();
        try (ZipContent zip = this.zipReader.open(file2);){
            for (IZipEntry entry : zip.getEntries()) {
                String entryName;
                if (entry.isDirectory() || (entryName = entry.getName()).startsWith("META-INF/versions/")) continue;
                try {
                    List<JavaClassReader> readers = entry.preferBytes() ? this.loadReaderFromZipEntry(entry.getBytes(), entryName, name) : this.loadReader(entry.getInputStream(), entryName, null, name);
                    result.addAll(readers);
                }
                catch (Exception e15) {
                    LOG.error("Failed to read zip entry: {}", (Object)entry, (Object)e15);
                }
            }
        }
        catch (Exception e16) {
            LOG.error("Failed to process zip file: {}", (Object)name, (Object)e16);
        }
        return result;
    }

    public static boolean isStartWithBytes(byte[] fileMagic, byte[] expectedBytes) {
        int len = expectedBytes.length;
        if (fileMagic.length < len) {
            return false;
        }
        for (int i15 = 0; i15 < len; ++i15) {
            if (fileMagic[i15] == expectedBytes[i15]) continue;
            return false;
        }
        return true;
    }

    private int getNextUniqId() {
        return this.classUniqId++;
    }
}

