/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections.debuginfo;

import jadx.api.plugins.input.data.ILocalVar;
import jadx.api.plugins.utils.Utils;
import jadx.plugins.input.dex.sections.SectionReader;
import org.jetbrains.annotations.Nullable;

public class DexLocalVar
implements ILocalVar {
    private static final int PARAM_START_OFFSET = -1;
    private final int regNum;
    private final String name;
    private final String type;
    @Nullable
    private final String sign;
    private boolean isEnd;
    private int startOffset;
    private int endOffset;

    public DexLocalVar(SectionReader dex, int regNum, int nameId, int typeId, int signId) {
        this(regNum, dex.getString(nameId), dex.getType(typeId), dex.getString(signId));
    }

    public DexLocalVar(int regNum, String name, String type) {
        this(regNum, name, type, null);
    }

    public DexLocalVar(int regNum, String name, String type, @Nullable String sign) {
        this.regNum = regNum;
        this.name = name;
        this.type = type;
        this.sign = sign;
    }

    public void start(int addr) {
        this.isEnd = false;
        this.startOffset = addr;
    }

    public boolean end(int addr) {
        if (this.isEnd) {
            return false;
        }
        this.isEnd = true;
        this.endOffset = addr;
        return true;
    }

    @Override
    public int getRegNum() {
        return this.regNum;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    @Nullable
    public String getSignature() {
        return this.sign;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    public void markAsParameter() {
        this.startOffset = -1;
    }

    @Override
    public boolean isMarkedAsParameter() {
        return this.startOffset == -1;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return (this.startOffset == -1 ? "-1 " : Utils.formatOffset(this.startOffset)) + "-" + (this.isEnd ? Utils.formatOffset(this.endOffset) : "      ") + ": r" + this.regNum + " '" + this.name + "' " + this.type + (String)(this.sign != null ? ", signature: " + this.sign : "");
    }
}

