/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelativePathTypeAdapter
extends TypeAdapter<Path> {
    private static final Logger LOG = LoggerFactory.getLogger(RelativePathTypeAdapter.class);
    private final Path basePath;

    public RelativePathTypeAdapter(Path basePath) {
        this.basePath = Objects.requireNonNull(basePath);
    }

    @Override
    public void write(JsonWriter out, Path value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            Path resultPath;
            value = value.toAbsolutePath().normalize();
            try {
                resultPath = this.basePath.relativize(value);
            }
            catch (IllegalArgumentException e15) {
                LOG.warn("Unable to build a relative path to {} - using absolute path", (Object)value);
                resultPath = value;
            }
            out.value(resultPath.toString());
        }
    }

    @Override
    public Path read(JsonReader in4) throws IOException {
        if (in4.peek() == JsonToken.NULL) {
            in4.nextNull();
            return null;
        }
        Path p15 = Paths.get(in4.nextString(), new String[0]);
        if (p15.isAbsolute()) {
            return p15;
        }
        return this.basePath.resolve(p15);
    }
}

