/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.update;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import jadx.core.Jadx;
import jadx.core.plugins.versions.VersionComparator;
import jadx.core.utils.GsonUtils;
import jadx.gui.settings.JadxUpdateChannel;
import jadx.gui.update.Artifact;
import jadx.gui.update.ArtifactList;
import jadx.gui.update.IUpdateCallback;
import jadx.gui.update.Release;
import jadx.gui.update.WorkflowRun;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tJ\n\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0002J/\u0010\u0010\u001a\u0004\u0018\u0001H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljadx/gui/update/JadxUpdate;", "", "jadxVersion", "", "<init>", "(Ljava/lang/String;)V", "check", "", "updateChannel", "Ljadx/gui/settings/JadxUpdateChannel;", "callback", "Ljadx/gui/update/IUpdateCallback;", "checkForNewRelease", "Ljadx/gui/update/Release;", "checkForNewStableRelease", "checkForNewUnstableRelease", "getAndParse", "T", "url", "klass", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "Companion", "jadx-gui"})
@SourceDebugExtension(value={"SMAP\nJadxUpdate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JadxUpdate.kt\njadx/gui/update/JadxUpdate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n777#2:114\n873#2,2:115\n*S KotlinDebug\n*F\n+ 1 JadxUpdate.kt\njadx/gui/update/JadxUpdate\n*L\n91#1:114\n91#1:115,2\n*E\n"})
public final class JadxUpdate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String jadxVersion;
    @NotNull
    private static final KLogger LOG = KotlinLogging.INSTANCE.logger(JadxUpdate::LOG$lambda$0);
    @NotNull
    public static final String JADX_ARTIFACTS_URL = "https://nightly.link/skylot/jadx/workflows/build-artifacts/master";
    @NotNull
    public static final String JADX_RELEASES_URL = "https://github.com/skylot/jadx/releases";
    @NotNull
    private static final String GITHUB_API_URL = "https://api.github.com/repos/skylot/jadx";
    @NotNull
    private static final String GITHUB_LATEST_ARTIFACTS_URL = "https://api.github.com/repos/skylot/jadx/actions/artifacts?per_page=5&page=1";
    @NotNull
    private static final String GITHUB_LATEST_RELEASE_URL = "https://api.github.com/repos/skylot/jadx/releases/latest";

    public JadxUpdate(@NotNull String jadxVersion) {
        Intrinsics.checkNotNullParameter(jadxVersion, "jadxVersion");
        this.jadxVersion = jadxVersion;
    }

    public /* synthetic */ JadxUpdate(String string, int n15, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n15 & 1) != 0) {
            String string2 = Jadx.getVersion();
            Intrinsics.checkNotNullExpressionValue(string2, "getVersion(...)");
            string = string2;
        }
        this(string);
    }

    public final void check(@NotNull JadxUpdateChannel updateChannel, @NotNull IUpdateCallback callback) {
        Thread thread2;
        Intrinsics.checkNotNullParameter((Object)updateChannel, "updateChannel");
        Intrinsics.checkNotNullParameter(callback, "callback");
        if (Intrinsics.areEqual(this.jadxVersion, "dev")) {
            LOG.debug(JadxUpdate::check$lambda$0);
            return;
        }
        Thread $this$check_u24lambda_u242 = thread2 = new Thread(() -> JadxUpdate.check$lambda$1(this, updateChannel, callback));
        boolean bl4 = false;
        $this$check_u24lambda_u242.setName("Jadx update thread");
        $this$check_u24lambda_u242.setPriority(1);
        $this$check_u24lambda_u242.start();
    }

    @Nullable
    public final Release checkForNewRelease(@NotNull JadxUpdateChannel updateChannel) {
        Release release;
        Intrinsics.checkNotNullParameter((Object)updateChannel, "updateChannel");
        LOG.info(JadxUpdate::checkForNewRelease$lambda$0);
        LOG.info(() -> JadxUpdate.checkForNewRelease$lambda$1(updateChannel, this));
        switch (WhenMappings.$EnumSwitchMapping$0[updateChannel.ordinal()]) {
            case 1: {
                release = this.checkForNewStableRelease();
                break;
            }
            case 2: {
                release = this.checkForNewUnstableRelease();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return release;
    }

    private final Release checkForNewStableRelease() {
        if (StringsKt.startsWith$default(this.jadxVersion, "r", false, 2, null)) {
            LOG.info(JadxUpdate::checkForNewStableRelease$lambda$0);
            return null;
        }
        Release release = (Release)this.getAndParse(GITHUB_LATEST_RELEASE_URL, Reflection.getOrCreateKotlinClass(Release.class));
        if (release == null) {
            return null;
        }
        Release latestRelease = release;
        if (VersionComparator.checkAndCompare(this.jadxVersion, latestRelease.getName()) >= 0) {
            return null;
        }
        LOG.info(() -> JadxUpdate.checkForNewStableRelease$lambda$1(latestRelease));
        return latestRelease;
    }

    /*
     * WARNING - void declaration
     */
    private final Release checkForNewUnstableRelease() {
        Collection destination$iv$iv;
        List<Artifact> list2;
        ArtifactList artifactList = (ArtifactList)this.getAndParse(GITHUB_LATEST_ARTIFACTS_URL, Reflection.getOrCreateKotlinClass(ArtifactList.class));
        if (artifactList != null && (list2 = artifactList.getArtifacts()) != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = list2;
            boolean $i$f$filter = false;
            void var6_5 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Artifact it = (Artifact)element$iv$iv;
                boolean bl4 = false;
                WorkflowRun workflowRun = it.getWorkflowRun();
                if (!Intrinsics.areEqual(workflowRun != null ? workflowRun.getBranch() : null, "master")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
        } else {
            return null;
        }
        List artifacts = (List)destination$iv$iv;
        if (artifacts.isEmpty()) {
            return null;
        }
        String latestVersion = StringsKt.substringBefore$default(StringsKt.removePrefix(StringsKt.removePrefix(((Artifact)artifacts.get(0)).getName(), (CharSequence)"jadx-gui-"), (CharSequence)"jadx-"), '-', null, 2, null);
        if (VersionComparator.checkAndCompare(this.jadxVersion, latestVersion) >= 0) {
            return null;
        }
        LOG.info(() -> JadxUpdate.checkForNewUnstableRelease$lambda$1(latestVersion));
        return new Release(latestVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T getAndParse(String url, KClass<T> klass) {
        KClass<T> kClass;
        HttpURLConnection con;
        Object object = new URI(url).toURL().openConnection();
        HttpURLConnection httpURLConnection = con = object instanceof HttpURLConnection ? (HttpURLConnection)object : null;
        if (con == null || con.getResponseCode() != 200) {
            return null;
        }
        object = con.getInputStream();
        Throwable throwable = null;
        try {
            KClass<T> kClass2;
            InputStream stream = (InputStream)object;
            boolean bl4 = false;
            Closeable closeable = new InputStreamReader(stream);
            Throwable throwable2 = null;
            try {
                InputStreamReader reader = (InputStreamReader)closeable;
                boolean bl5 = false;
                kClass2 = GsonUtils.buildGson().fromJson((Reader)reader, JvmClassMappingKt.getJavaClass(klass));
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable2);
            }
            kClass = kClass2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
        return (T)kClass;
    }

    private static final Object check$lambda$1$0() {
        return "No updates found";
    }

    private static final Object check$lambda$1$1() {
        return "Jadx update error";
    }

    private static final Object check$lambda$0() {
        return "Ignore update check: development version";
    }

    private static final void check$lambda$1(JadxUpdate this$0, JadxUpdateChannel $updateChannel, IUpdateCallback $callback) {
        try {
            Release release = this$0.checkForNewRelease($updateChannel);
            if (release != null) {
                $callback.onUpdate(release);
            } else {
                LOG.info(JadxUpdate::check$lambda$1$0);
            }
        }
        catch (Exception e15) {
            LOG.warn(e15, JadxUpdate::check$lambda$1$1);
        }
    }

    private static final Object checkForNewRelease$lambda$0() {
        return "Checking for updates...";
    }

    private static final Object checkForNewRelease$lambda$1(JadxUpdateChannel $updateChannel, JadxUpdate this$0) {
        return "Update channel: " + $updateChannel + ", current version: " + this$0.jadxVersion;
    }

    private static final Object checkForNewStableRelease$lambda$0() {
        return "Skip update check: can't compare unstable and stable versions";
    }

    private static final Object checkForNewStableRelease$lambda$1(Release $latestRelease) {
        return "Found new jadx version: " + $latestRelease.getName();
    }

    private static final Object checkForNewUnstableRelease$lambda$1(String $latestVersion) {
        return "Found new unstable version: " + $latestVersion;
    }

    private static final Unit LOG$lambda$0() {
        return Unit.INSTANCE;
    }

    public JadxUpdate() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljadx/gui/update/JadxUpdate$Companion;", "", "<init>", "()V", "LOG", "Lio/github/oshai/kotlinlogging/KLogger;", "JADX_ARTIFACTS_URL", "", "JADX_RELEASES_URL", "GITHUB_API_URL", "GITHUB_LATEST_ARTIFACTS_URL", "GITHUB_LATEST_RELEASE_URL", "jadx-gui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JadxUpdateChannel.values().length];
            try {
                nArray[JadxUpdateChannel.STABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JadxUpdateChannel.UNSTABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

