/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.tab.dnd;

import jadx.gui.settings.JadxSettings;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.ui.tab.dnd.TabDndGestureListener;
import jadx.gui.ui.tab.dnd.TabDndGhostPane;
import jadx.gui.ui.tab.dnd.TabDndTargetListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public class TabDndController {
    private final transient JTabbedPane pane;
    private static final int DROP_TARGET_MARK_SIZE = 4;
    private static final int SCROLL_AREA_SIZE = 30;
    private static final int SCROLL_AREA_EXTRA = 30;
    private static final String ACTION_SCROLL_FORWARD = "scrollTabsForwardAction";
    private static final String ACTION_SCROLL_BACKWARD = "scrollTabsBackwardAction";
    private final transient TabDndGhostPane tabDndGhostPane;
    protected int dragTabIndex = -1;
    protected boolean drawGhost = true;
    protected boolean paintScrollTriggerAreas = false;
    protected Rectangle rectBackward = new Rectangle();
    protected Rectangle rectForward = new Rectangle();
    private boolean isDragging = false;

    public TabDndController(TabbedPane pane, JadxSettings settings) {
        pane.setDnd(this);
        this.pane = pane;
        this.tabDndGhostPane = new TabDndGhostPane(this, settings);
        new DropTarget(this.tabDndGhostPane, 3, new TabDndTargetListener(this), true);
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(pane, 3, new TabDndGestureListener(this));
    }

    public static boolean isHorizontalTabPlacement(int tabPlacement) {
        return tabPlacement == 1 || tabPlacement == 3;
    }

    public void scrollIfNeeded(Point glassPt) {
        Rectangle r15 = this.getTabAreaBounds();
        boolean isHorizontal = TabDndController.isHorizontalTabPlacement(this.pane.getTabPlacement());
        if (isHorizontal) {
            this.rectForward.setBounds(r15.x + r15.width - 30 - 30, r15.y, 60, r15.height);
        } else {
            this.rectForward.setBounds(r15.x, r15.y + r15.height - 30 - 30, r15.width, 60);
        }
        this.rectForward = SwingUtilities.convertRectangle(this.pane.getParent(), this.rectForward, this.tabDndGhostPane);
        if (this.rectForward.contains(glassPt)) {
            this.clickScrollButton(ACTION_SCROLL_FORWARD);
        }
        if (isHorizontal) {
            this.rectBackward.setBounds(r15.x, r15.y, 30, r15.height);
        } else {
            this.rectBackward.setBounds(r15.x, r15.y, r15.width, 30);
        }
        this.rectBackward = SwingUtilities.convertRectangle(this.pane.getParent(), this.rectBackward, this.tabDndGhostPane);
        if (this.rectBackward.contains(glassPt)) {
            this.clickScrollButton(ACTION_SCROLL_BACKWARD);
        }
    }

    private void clickScrollButton(String actionKey) {
        Component scrollButton;
        Component forwardButton = null;
        Component backwardButton = null;
        for (Component c15 : this.pane.getComponents()) {
            if (!(c15 instanceof JButton)) continue;
            if (Objects.isNull(forwardButton)) {
                forwardButton = (JButton)c15;
                continue;
            }
            backwardButton = (JButton)c15;
            break;
        }
        Component component = scrollButton = ACTION_SCROLL_FORWARD.equals(actionKey) ? forwardButton : backwardButton;
        if (scrollButton != null && scrollButton.isEnabled()) {
            ((AbstractButton)scrollButton).doClick();
        }
    }

    protected int getTargetTabIndex(Point glassPt) {
        Point tabPt = SwingUtilities.convertPoint(this.tabDndGhostPane, glassPt, this.pane);
        boolean isHorizontal = TabDndController.isHorizontalTabPlacement(this.pane.getTabPlacement());
        for (int i15 = 0; i15 < this.pane.getTabCount(); ++i15) {
            Rectangle r15 = this.pane.getBoundsAt(i15);
            if (isHorizontal) {
                r15.width = r15.width / 2 + 1;
            } else {
                r15.height = r15.height / 2 + 1;
            }
            if (r15.contains(tabPt)) {
                return i15;
            }
            if (isHorizontal) {
                r15.x += r15.width;
            } else {
                r15.y += r15.height;
            }
            if (!r15.contains(tabPt)) continue;
            return i15 + 1;
        }
        int count = this.pane.getTabCount();
        if (count == 0) {
            return -1;
        }
        Rectangle lastRect = this.pane.getBoundsAt(count - 1);
        Point d15 = isHorizontal ? new Point(1, 0) : new Point(0, 1);
        lastRect.translate(lastRect.width * d15.x, lastRect.height * d15.y);
        return lastRect.contains(tabPt) ? count : -1;
    }

    protected void swapTabs(int oldIdx, int newIdx) {
        if (newIdx < 0 || oldIdx == newIdx) {
            return;
        }
        Component cmp = this.pane.getComponentAt(oldIdx);
        Component tab = this.pane.getTabComponentAt(oldIdx);
        String title = this.pane.getTitleAt(oldIdx);
        Icon icon = this.pane.getIconAt(oldIdx);
        String tip = this.pane.getToolTipTextAt(oldIdx);
        boolean isEnabled = this.pane.isEnabledAt(oldIdx);
        newIdx = oldIdx > newIdx ? newIdx : newIdx - 1;
        this.pane.remove(oldIdx);
        this.pane.insertTab(title, icon, cmp, tip, newIdx);
        this.pane.setEnabledAt(newIdx, isEnabled);
        if (isEnabled) {
            this.pane.setSelectedIndex(newIdx);
        }
        this.pane.setTabComponentAt(newIdx, tab);
    }

    protected void updateTargetMark(int tabIdx) {
        boolean isSideNeighbor;
        boolean bl4 = isSideNeighbor = tabIdx < 0 || this.dragTabIndex == tabIdx || tabIdx == this.dragTabIndex + 1;
        if (isSideNeighbor) {
            this.tabDndGhostPane.setTargetRect(0, 0, 0, 0);
            return;
        }
        Rectangle boundsRect = this.pane.getBoundsAt(Math.max(0, tabIdx - 1));
        Rectangle r15 = SwingUtilities.convertRectangle(this.pane, boundsRect, this.tabDndGhostPane);
        int a15 = Math.min(tabIdx, 1);
        if (TabDndController.isHorizontalTabPlacement(this.pane.getTabPlacement())) {
            this.tabDndGhostPane.setTargetRect(r15.x + r15.width * a15 - 2, r15.y, 4, r15.height);
        } else {
            this.tabDndGhostPane.setTargetRect(r15.x, r15.y + r15.height * a15 - 2, r15.width, 4);
        }
    }

    protected void initGlassPane(Point tabPt) {
        this.pane.getRootPane().setGlassPane(this.tabDndGhostPane);
        if (this.drawGhost) {
            Component c15 = this.pane.getTabComponentAt(this.dragTabIndex);
            if (c15 == null) {
                return;
            }
            Dimension d15 = c15.getPreferredSize();
            switch (this.tabDndGhostPane.getGhostType()) {
                case IMAGE: {
                    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice device = env.getDefaultScreenDevice();
                    GraphicsConfiguration config = device.getDefaultConfiguration();
                    BufferedImage image = config.createCompatibleImage(d15.width, d15.height, 3);
                    Graphics2D g25 = image.createGraphics();
                    SwingUtilities.paintComponent(g25, c15, this.tabDndGhostPane, 0, 0, d15.width, d15.height);
                    g25.dispose();
                    this.tabDndGhostPane.setGhostImage(image);
                    this.pane.setTabComponentAt(this.dragTabIndex, c15);
                    break;
                }
                case OUTLINE: {
                    this.tabDndGhostPane.setGhostSize(d15);
                    break;
                }
            }
        }
        Point glassPt = SwingUtilities.convertPoint(this.pane, tabPt, this.tabDndGhostPane);
        this.tabDndGhostPane.setPoint(glassPt);
        this.tabDndGhostPane.setVisible(true);
    }

    protected Rectangle getTabAreaBounds() {
        Rectangle tabbedRect = this.pane.getBounds();
        Rectangle compRect = this.pane.getSelectedComponent() != null ? this.pane.getSelectedComponent().getBounds() : new Rectangle();
        int tabPlacement = this.pane.getTabPlacement();
        if (TabDndController.isHorizontalTabPlacement(tabPlacement)) {
            tabbedRect.height -= compRect.height;
            if (tabPlacement == 3) {
                tabbedRect.y += compRect.y + compRect.height;
            }
        } else {
            tabbedRect.width -= compRect.width;
            if (tabPlacement == 4) {
                tabbedRect.x += compRect.x + compRect.width;
            }
        }
        tabbedRect.grow(2, 2);
        return tabbedRect;
    }

    public void onPaintGlassPane(Graphics2D g15) {
        boolean isScrollLayout;
        boolean bl4 = isScrollLayout = this.pane.getTabLayoutPolicy() == 1;
        if (isScrollLayout && this.paintScrollTriggerAreas) {
            g15.setPaint(this.tabDndGhostPane.getColor());
            g15.fill(this.rectBackward);
            g15.fill(this.rectForward);
        }
    }

    public boolean onStartDrag(Point pt4) {
        this.setDragging(true);
        int idx = this.pane.indexAtLocation(pt4.x, pt4.y);
        int selIdx = this.pane.getSelectedIndex();
        boolean isTabRunsRotated = !(this.pane.getUI() instanceof MetalTabbedPaneUI) && this.pane.getTabLayoutPolicy() == 0 && idx != selIdx;
        int n15 = this.dragTabIndex = isTabRunsRotated ? selIdx : idx;
        if (this.dragTabIndex >= 0 && this.pane.isEnabledAt(this.dragTabIndex)) {
            this.initGlassPane(pt4);
            return true;
        }
        return false;
    }

    public void loadSettings() {
        this.tabDndGhostPane.loadSettings();
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setDragging(boolean dragging) {
        this.isDragging = dragging;
    }

    public TabDndGhostPane getDndGhostPane() {
        return this.tabDndGhostPane;
    }
}

