/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.filedialog;

import jadx.core.utils.ListUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.files.FileUtils;
import jadx.gui.ui.filedialog.FileDialogWrapper;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;

class CustomFileDialog {
    private final FileDialogWrapper data;

    public CustomFileDialog(FileDialogWrapper data) {
        this.data = data;
    }

    public List<Path> showDialog() {
        FileDialog fileDialog = new FileDialog((Frame)this.data.getMainWindow(), this.data.getTitle());
        fileDialog.setMode(this.data.isOpen() ? 0 : 1);
        fileDialog.setMultipleMode(true);
        List<String> fileExtList = this.data.getFileExtList();
        if (Utils.notEmpty(fileExtList)) {
            fileDialog.setFilenameFilter((dir, name) -> ListUtils.anyMatch(fileExtList, name::endsWith));
        }
        if (this.data.getSelectedFile() != null) {
            fileDialog.setFile(this.data.getSelectedFile().toAbsolutePath().toString());
        }
        if (this.data.getCurrentDir() != null) {
            fileDialog.setDirectory(this.data.getCurrentDir().toAbsolutePath().toString());
        }
        fileDialog.setVisible(true);
        File[] selectedFiles = fileDialog.getFiles();
        if (!Utils.isEmpty(selectedFiles)) {
            this.data.setCurrentDir(Paths.get(fileDialog.getDirectory(), new String[0]));
            return FileUtils.toPathsWithTrim(selectedFiles);
        }
        if (fileDialog.getFile() != null) {
            return Collections.singletonList(FileUtils.toPathWithTrim(fileDialog.getFile()));
        }
        return Collections.emptyList();
    }
}

