/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.cache.code;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.processors.PublishProcessor;
import jadx.api.ICodeCache;
import jadx.api.ICodeInfo;
import jadx.api.impl.DelegateCodeCache;
import jadx.gui.utils.UiUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeStringCache
extends DelegateCodeCache {
    private static final Logger LOG = LoggerFactory.getLogger(CodeStringCache.class);
    private final Map<String, String> codeCache = new ConcurrentHashMap<String, String>();
    private final Subscriber<Boolean> subscriber;
    private final Disposable disposable;

    public CodeStringCache(ICodeCache backCache) {
        super(backCache);
        PublishProcessor<Boolean> processor = PublishProcessor.create();
        this.subscriber = processor;
        this.disposable = processor.debounce(3L, TimeUnit.SECONDS).map(v15 -> UiUtils.isFreeMemoryAvailable()).filter(v15 -> v15 == false).subscribe(v15 -> {
            LOG.warn("Free memory is low! Reset code strings cache. Cache size {}", (Object)this.codeCache.size());
            this.codeCache.clear();
            System.gc();
        });
    }

    @Override
    @Nullable
    public String getCode(String clsFullName) {
        this.subscriber.onNext(Boolean.TRUE);
        String code = this.codeCache.get(clsFullName);
        if (code != null) {
            return code;
        }
        String backCode = this.backCache.getCode(clsFullName);
        if (backCode != null) {
            this.codeCache.put(clsFullName, backCode);
        }
        return backCode;
    }

    @Override
    @NotNull
    public ICodeInfo get(String clsFullName) {
        this.subscriber.onNext(Boolean.TRUE);
        return super.get(clsFullName);
    }

    @Override
    public void add(String clsFullName, ICodeInfo codeInfo) {
        this.subscriber.onNext(Boolean.TRUE);
        this.codeCache.put(clsFullName, codeInfo.getCodeStr());
        this.backCache.add(clsFullName, codeInfo);
    }

    @Override
    public void remove(String clsFullName) {
        this.codeCache.remove(clsFullName);
        this.backCache.remove(clsFullName);
    }

    @Override
    public void close() throws IOException {
        try {
            this.backCache.close();
        }
        finally {
            this.codeCache.clear();
            this.subscriber.onComplete();
            this.disposable.dispose();
        }
    }
}

