/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.api.JadxArgs;
import jadx.api.impl.SimpleCodeWriter;
import jadx.core.utils.StringUtils;
import jadx.core.xmlgen.ManifestAttributes;
import jadx.core.xmlgen.ParserConstants;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.ResourceStorage;
import jadx.core.xmlgen.StringFormattedCheck;
import jadx.core.xmlgen.XmlGenUtils;
import jadx.core.xmlgen.entry.ProtoValue;
import jadx.core.xmlgen.entry.RawNamedValue;
import jadx.core.xmlgen.entry.ResourceEntry;
import jadx.core.xmlgen.entry.ValuesParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResXmlGen {
    private static final Set<String> SKIP_RES_TYPES = new HashSet<String>(Arrays.asList("anim", "animator", "font", "id", "interpolator", "layout", "menu", "mipmap", "navigation", "raw", "transition", "xml"));
    private final ResourceStorage resStorage;
    private final ValuesParser vp;
    private final ManifestAttributes manifestAttributes;

    public ResXmlGen(ResourceStorage resStorage, ValuesParser vp4, ManifestAttributes manifestAttributes) {
        this.resStorage = resStorage;
        this.vp = vp4;
        this.manifestAttributes = manifestAttributes;
    }

    public List<ResContainer> makeResourcesXml(JadxArgs args) {
        HashMap<String, ICodeWriter> contMap = new HashMap<String, ICodeWriter>();
        for (ResourceEntry ri4 : this.resStorage.getResources()) {
            if (SKIP_RES_TYPES.contains(ri4.getTypeName())) continue;
            String fn4 = this.getFileName(ri4);
            ICodeWriter cw4 = (ICodeWriter)contMap.get(fn4);
            if (cw4 == null) {
                cw4 = new SimpleCodeWriter(args);
                cw4.add("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                cw4.startLine("<resources>");
                cw4.incIndent();
                contMap.put(fn4, cw4);
            }
            this.addValue(cw4, ri4);
        }
        ArrayList<ResContainer> files = new ArrayList<ResContainer>(contMap.size());
        for (Map.Entry entry : contMap.entrySet()) {
            String fileName = (String)entry.getKey();
            ICodeWriter content = (ICodeWriter)entry.getValue();
            content.decIndent();
            content.startLine("</resources>");
            ICodeInfo codeInfo = content.finish();
            files.add(ResContainer.textResource(fileName, codeInfo));
        }
        Collections.sort(files);
        return files;
    }

    private void addValue(ICodeWriter cw4, ResourceEntry ri4) {
        if (ri4.getProtoValue() != null) {
            ProtoValue protoValue = ri4.getProtoValue();
            if (protoValue.getValue() != null && protoValue.getNamedValues() == null) {
                this.addSimpleValue(cw4, ri4.getTypeName(), ri4.getTypeName(), "name", ri4.getKeyName(), protoValue.getValue());
            } else {
                cw4.startLine();
                cw4.add('<').add(ri4.getTypeName()).add(' ');
                String itemTag = "item";
                cw4.add("name=\"").add(ri4.getKeyName()).add('\"');
                if (ri4.getTypeName().equals("attr") && protoValue.getValue() != null) {
                    cw4.add(" format=\"").add(protoValue.getValue()).add('\"');
                }
                if (protoValue.getParent() != null) {
                    cw4.add(" parent=\"").add(protoValue.getParent()).add('\"');
                }
                cw4.add(">");
                cw4.incIndent();
                for (ProtoValue value : protoValue.getNamedValues()) {
                    this.addProtoItem(cw4, itemTag, ri4.getTypeName(), value);
                }
                cw4.decIndent();
                cw4.startLine().add("</").add(ri4.getTypeName()).add('>');
            }
        } else if (ri4.getSimpleValue() != null) {
            String valueStr = this.vp.decodeValue(ri4.getSimpleValue());
            this.addSimpleValue(cw4, ri4.getTypeName(), ri4.getTypeName(), "name", ri4.getKeyName(), valueStr);
        } else {
            boolean skipNamedValues = false;
            cw4.startLine();
            cw4.add('<').add(ri4.getTypeName()).add(" name=\"");
            String itemTag = "item";
            if (ri4.getTypeName().equals("attr") && !ri4.getNamedValues().isEmpty()) {
                cw4.add(ri4.getKeyName());
                int type = ri4.getNamedValues().get(0).getRawValue().getData();
                if ((type & 0x10000) != 0) {
                    itemTag = "enum";
                } else if ((type & 0x20000) != 0) {
                    itemTag = "flag";
                }
                String formatValue = XmlGenUtils.getAttrTypeAsString(type);
                if (formatValue != null) {
                    cw4.add("\" format=\"").add(formatValue);
                }
                if (ri4.getNamedValues().size() > 1) {
                    for (RawNamedValue rv4 : ri4.getNamedValues()) {
                        if (rv4.getNameRef() != ParserConstants.ATTR_MIN) continue;
                        cw4.add("\" min=\"").add(String.valueOf(rv4.getRawValue().getData()));
                        skipNamedValues = true;
                    }
                }
            } else {
                cw4.add(ri4.getKeyName());
            }
            if (ri4.getTypeName().equals("style") || ri4.getParentRef() != 0) {
                cw4.add("\" parent=\"");
                if (ri4.getParentRef() != 0) {
                    String parent = this.vp.decodeValue(1, ri4.getParentRef());
                    cw4.add(parent);
                }
            }
            cw4.add("\">");
            if (!skipNamedValues) {
                cw4.incIndent();
                for (RawNamedValue value : ri4.getNamedValues()) {
                    this.addItem(cw4, itemTag, ri4.getTypeName(), value);
                }
                cw4.decIndent();
            }
            cw4.startLine().add("</").add(ri4.getTypeName()).add('>');
        }
    }

    private void addProtoItem(ICodeWriter cw4, String itemTag, String typeName, ProtoValue protoValue) {
        String name = protoValue.getName();
        String value = protoValue.getValue();
        switch (typeName) {
            case "attr": {
                if (name == null) break;
                this.addSimpleValue(cw4, typeName, itemTag, name, value, "");
                break;
            }
            case "style": {
                if (name == null) break;
                this.addSimpleValue(cw4, typeName, itemTag, name, "", value);
                break;
            }
            case "plurals": {
                this.addSimpleValue(cw4, typeName, itemTag, "quantity", name, value);
                break;
            }
            default: {
                this.addSimpleValue(cw4, typeName, itemTag, null, null, value);
            }
        }
    }

    private void addItem(ICodeWriter cw4, String itemTag, String typeName, RawNamedValue value) {
        String nameStr = this.vp.decodeNameRef(value.getNameRef());
        String valueStr = this.vp.decodeValue(value.getRawValue());
        int dataType = value.getRawValue().getDataType();
        if (!typeName.equals("attr")) {
            String newVal;
            int intVal2;
            if (dataType == 1 && (valueStr == null || valueStr.equals("0"))) {
                valueStr = "@null";
            }
            if (dataType == 16 && nameStr != null) {
                try {
                    intVal2 = Integer.parseInt(valueStr);
                    newVal = this.manifestAttributes.decode(nameStr.replace("android:", "").replace("attr.", ""), intVal2);
                    if (newVal != null) {
                        valueStr = newVal;
                    }
                }
                catch (NumberFormatException intVal2) {
                    // empty catch block
                }
            }
            if (dataType == 17 && nameStr != null) {
                try {
                    intVal2 = Integer.decode(valueStr);
                    newVal = this.manifestAttributes.decode(nameStr.replace("android:", "").replace("attr.", ""), intVal2);
                    if (newVal != null) {
                        valueStr = newVal;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        switch (typeName) {
            case "attr": {
                if (nameStr == null) break;
                this.addSimpleValue(cw4, typeName, itemTag, nameStr, valueStr, "");
                break;
            }
            case "style": {
                if (nameStr == null) break;
                this.addSimpleValue(cw4, typeName, itemTag, nameStr, "", valueStr);
                break;
            }
            case "plurals": {
                String quantity = ParserConstants.PLURALS_MAP.get(value.getNameRef());
                this.addSimpleValue(cw4, typeName, itemTag, "quantity", quantity, valueStr);
                break;
            }
            default: {
                this.addSimpleValue(cw4, typeName, itemTag, null, null, valueStr);
            }
        }
    }

    private void addSimpleValue(ICodeWriter cw4, String typeName, String itemTag, String attrName, String attrValue, String valueStr) {
        if (valueStr == null) {
            return;
        }
        if (valueStr.startsWith("res/")) {
            return;
        }
        cw4.startLine();
        cw4.add('<').add(itemTag);
        if (attrName != null && attrValue != null) {
            if (typeName.equals("attr")) {
                cw4.add(' ').add("name=\"").add(attrName.replace("id.", "")).add("\" value=\"").add(attrValue).add('\"');
            } else if (typeName.equals("style")) {
                cw4.add(' ').add("name=\"").add(attrName.replace("attr.", "")).add('\"');
            } else {
                cw4.add(' ').add(attrName).add("=\"").add(attrValue).add('\"');
            }
        }
        if (itemTag.equals("string") && valueStr.contains("%") && StringFormattedCheck.hasMultipleNonPositionalSubstitutions(valueStr)) {
            cw4.add(" formatted=\"false\"");
        }
        if (valueStr.isEmpty()) {
            cw4.add(" />");
        } else {
            cw4.add('>');
            if (itemTag.equals("string") || typeName.equals("array") && valueStr.charAt(0) != '@') {
                cw4.add(StringUtils.escapeResStrValue(valueStr));
            } else {
                cw4.add(StringUtils.escapeResValue(valueStr));
            }
            cw4.add("</").add(itemTag).add('>');
        }
    }

    private String getFileName(ResourceEntry ri4) {
        StringBuilder sb5 = new StringBuilder();
        String qualifiers = ri4.getConfig();
        sb5.append("res/values");
        if (!qualifiers.isEmpty()) {
            sb5.append(qualifiers);
        }
        sb5.append('/');
        sb5.append(ri4.getTypeName());
        if (!ri4.getTypeName().endsWith("s")) {
            sb5.append('s');
        }
        sb5.append(".xml");
        return sb5.toString();
    }
}

