/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.api.JadxArgs;
import jadx.api.args.IntegerFormat;
import jadx.core.deobf.NameMapper;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.IntConsumer;
import org.jetbrains.annotations.Nullable;

public class StringUtils {
    private static final StringUtils DEFAULT_INSTANCE = new StringUtils(new JadxArgs());
    private static final String WHITES = " \t\r\n\f\b";
    private static final String WORD_SEPARATORS = " \t\r\n\f\b(\")<,>{}=+-*/|[]\\:;'.`~!#^&";
    private final boolean escapeUnicode;
    private final IntegerFormat integerFormat;

    public static StringUtils getInstance() {
        return DEFAULT_INSTANCE;
    }

    public StringUtils(JadxArgs args) {
        this.escapeUnicode = args.isEscapeUnicode();
        this.integerFormat = args.getIntegerFormat();
    }

    public IntegerFormat getIntegerFormat() {
        return this.integerFormat;
    }

    public static void visitCodePoints(String str, IntConsumer visitor2) {
        int codePoint;
        int len = str.length();
        for (int offset = 0; offset < len; offset += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(offset);
            visitor2.accept(codePoint);
        }
    }

    public String unescapeString(String str) {
        int len = str.length();
        if (len == 0) {
            return "\"\"";
        }
        StringBuilder res = new StringBuilder();
        res.append('\"');
        StringUtils.visitCodePoints(str, codePoint -> this.processCodePoint(codePoint, res));
        res.append('\"');
        return res.toString();
    }

    private void processCodePoint(int codePoint, StringBuilder res) {
        String str = this.getSpecialStringForCodePoint(codePoint);
        if (str != null) {
            res.append(str);
            return;
        }
        if (this.isEscapeNeededForCodePoint(codePoint)) {
            res.append("\\u").append(String.format("%04x", codePoint));
        } else {
            res.appendCodePoint(codePoint);
        }
    }

    private boolean isEscapeNeededForCodePoint(int codePoint) {
        if (codePoint < 32) {
            return true;
        }
        if (codePoint < 127) {
            return false;
        }
        if (this.escapeUnicode) {
            return true;
        }
        return !NameMapper.isPrintableCodePoint(codePoint);
    }

    public String unescapeChar(char c15, boolean explicitCast) {
        if (c15 == '\'') {
            return "'\\''";
        }
        String str = this.getSpecialStringForCodePoint(c15);
        if (str != null) {
            return "'" + str + "'";
        }
        if (c15 >= '\u007f' && this.escapeUnicode) {
            return String.format("'\\u%04x'", c15);
        }
        if (NameMapper.isPrintableChar(c15)) {
            return "'" + c15 + "'";
        }
        String intStr = Integer.toString(c15);
        return explicitCast ? "(char) " + intStr : intStr;
    }

    public String unescapeChar(char ch4) {
        return this.unescapeChar(ch4, false);
    }

    @Nullable
    private String getSpecialStringForCodePoint(int c15) {
        switch (c15) {
            case 10: {
                return "\\n";
            }
            case 13: {
                return "\\r";
            }
            case 9: {
                return "\\t";
            }
            case 8: {
                return "\\b";
            }
            case 12: {
                return "\\f";
            }
            case 39: {
                return "'";
            }
            case 34: {
                return "\\\"";
            }
            case 92: {
                return "\\\\";
            }
        }
        return null;
    }

    public static String escape(String str) {
        int len = str.length();
        StringBuilder sb5 = new StringBuilder(len);
        block5: for (int i15 = 0; i15 < len; ++i15) {
            char c15 = str.charAt(i15);
            switch (c15) {
                case ' ': 
                case '$': 
                case ',': 
                case '.': 
                case '/': 
                case ';': 
                case '<': {
                    sb5.append('_');
                    continue block5;
                }
                case '[': {
                    sb5.append('A');
                    continue block5;
                }
                case '*': 
                case '>': 
                case '?': 
                case ']': {
                    continue block5;
                }
                default: {
                    sb5.append(c15);
                }
            }
        }
        return sb5.toString();
    }

    public static String escapeXML(String str) {
        int len = str.length();
        StringBuilder sb5 = new StringBuilder(len);
        for (int i15 = 0; i15 < len; ++i15) {
            char c15 = str.charAt(i15);
            String replace = StringUtils.escapeXmlChar(c15);
            if (replace != null) {
                sb5.append(replace);
                continue;
            }
            sb5.append(c15);
        }
        return sb5.toString();
    }

    public static String escapeResValue(String str) {
        int len = str.length();
        StringBuilder sb5 = new StringBuilder(len);
        for (int i15 = 0; i15 < len; ++i15) {
            char c15 = str.charAt(i15);
            StringUtils.commonEscapeAndAppend(sb5, c15);
        }
        return sb5.toString();
    }

    public static String escapeResStrValue(String str) {
        int len = str.length();
        StringBuilder sb5 = new StringBuilder(len);
        block4: for (int i15 = 0; i15 < len; ++i15) {
            char c15 = str.charAt(i15);
            switch (c15) {
                case '\"': {
                    sb5.append("\\\"");
                    continue block4;
                }
                case '\'': {
                    sb5.append("\\'");
                    continue block4;
                }
                default: {
                    StringUtils.commonEscapeAndAppend(sb5, c15);
                }
            }
        }
        return sb5.toString();
    }

    private static String escapeXmlChar(char c15) {
        if (c15 <= '\u001f') {
            return "\\" + c15;
        }
        switch (c15) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return null;
    }

    private static String escapeWhiteSpaceChar(char c15) {
        switch (c15) {
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
        }
        return null;
    }

    private static void commonEscapeAndAppend(StringBuilder sb5, char c15) {
        String replace = StringUtils.escapeWhiteSpaceChar(c15);
        if (replace == null) {
            replace = StringUtils.escapeXmlChar(c15);
        }
        if (replace != null) {
            sb5.append(replace);
        } else {
            sb5.append(c15);
        }
    }

    public static boolean notEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean notBlank(String str) {
        return StringUtils.notEmpty(str) && !str.trim().isEmpty();
    }

    public static int countMatches(String str, String subStr) {
        if (str == null || str.isEmpty() || subStr == null || subStr.isEmpty()) {
            return 0;
        }
        int subStrLen = subStr.length();
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(subStr, idx)) != -1) {
            ++count;
            idx += subStrLen;
        }
        return count;
    }

    public static boolean containsChar(String str, char ch4) {
        return str.indexOf(ch4) != -1;
    }

    public static String removeChar(String str, char ch4) {
        int pos = str.indexOf(ch4);
        if (pos == -1) {
            return str;
        }
        StringBuilder sb5 = new StringBuilder(str.length());
        int cur = 0;
        int next = pos;
        do {
            sb5.append(str, cur, next);
        } while ((next = str.indexOf(ch4, cur = next + 1)) != -1);
        sb5.append(str, cur, str.length());
        return sb5.toString();
    }

    public static int countLinesByPos(String content, int pos, int start) {
        if (start >= pos) {
            return 0;
        }
        int count = 0;
        int tempPos = start;
        while ((tempPos = content.indexOf("\n", tempPos)) != -1 && tempPos < pos) {
            ++count;
            if (++tempPos < content.length()) continue;
        }
        return count;
    }

    public static String getLine(String content, int pos, int end) {
        int endPos;
        int headPos;
        if (pos >= content.length()) {
            return "";
        }
        if (end != -1) {
            if (end > content.length()) {
                end = content.length() - 1;
            }
        } else {
            end = pos + 1;
        }
        if ((headPos = content.lastIndexOf("\n", pos)) == -1) {
            headPos = 0;
        }
        if ((endPos = content.indexOf("\n", end)) == -1) {
            endPos = content.length();
        }
        return content.substring(headPos, endPos);
    }

    public static boolean isWhite(char chr) {
        return WHITES.indexOf(chr) != -1;
    }

    public static boolean isWordSeparator(char chr) {
        return WORD_SEPARATORS.indexOf(chr) != -1;
    }

    public static String removeSuffix(String str, String suffix) {
        if (str.endsWith(suffix)) {
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    @Nullable
    public static String getPrefix(String str, String delim) {
        int idx = str.indexOf(delim);
        if (idx != -1) {
            return str.substring(0, idx);
        }
        return null;
    }

    public static String getDateText() {
        return new SimpleDateFormat("HH:mm:ss").format(new Date());
    }

    private String formatNumber(long number, int bytesLen, boolean cast) {
        Object numStr;
        if (this.integerFormat.isHexadecimal()) {
            String hexStr = Long.toHexString(number);
            if (number < 0L) {
                int len = hexStr.length();
                numStr = "0x" + hexStr.substring(len - bytesLen * 2, len);
                cast = true;
            } else {
                numStr = "0x" + hexStr;
            }
        } else {
            numStr = Long.toString(number);
        }
        if (bytesLen == 8 && (number == Long.MIN_VALUE || Math.abs(number) >= Integer.MAX_VALUE)) {
            cast = true;
        }
        if (cast) {
            if (bytesLen == 8) {
                return (String)numStr + "L";
            }
            return StringUtils.getCastStr(bytesLen) + (String)numStr;
        }
        return numStr;
    }

    private static String getCastStr(int bytesLen) {
        switch (bytesLen) {
            case 1: {
                return "(byte) ";
            }
            case 2: {
                return "(short) ";
            }
            case 4: {
                return "(int) ";
            }
            case 8: {
                return "(long) ";
            }
        }
        throw new JadxRuntimeException("Unexpected number type length: " + bytesLen);
    }

    public String formatByte(long l15, boolean cast) {
        return this.formatNumber(l15, 1, cast);
    }

    public String formatShort(long l15, boolean cast) {
        if (this.integerFormat == IntegerFormat.AUTO) {
            switch ((short)l15) {
                case 32767: {
                    return "Short.MAX_VALUE";
                }
                case -32768: {
                    return "Short.MIN_VALUE";
                }
            }
        }
        return this.formatNumber(l15, 2, cast);
    }

    public String formatInteger(long l15, boolean cast) {
        if (this.integerFormat == IntegerFormat.AUTO) {
            switch ((int)l15) {
                case 0x7FFFFFFF: {
                    return "Integer.MAX_VALUE";
                }
                case -2147483648: {
                    return "Integer.MIN_VALUE";
                }
            }
        }
        return this.formatNumber(l15, 4, cast);
    }

    public String formatLong(long l15, boolean cast) {
        if (this.integerFormat == IntegerFormat.AUTO) {
            if (l15 == Long.MAX_VALUE) {
                return "Long.MAX_VALUE";
            }
            if (l15 == Long.MIN_VALUE) {
                return "Long.MIN_VALUE";
            }
        }
        return this.formatNumber(l15, 8, cast);
    }

    public static String formatDouble(double d15) {
        if (Double.isNaN(d15)) {
            return "Double.NaN";
        }
        if (d15 == Double.NEGATIVE_INFINITY) {
            return "Double.NEGATIVE_INFINITY";
        }
        if (d15 == Double.POSITIVE_INFINITY) {
            return "Double.POSITIVE_INFINITY";
        }
        if (d15 == Double.MIN_VALUE) {
            return "Double.MIN_VALUE";
        }
        if (d15 == Double.MAX_VALUE) {
            return "Double.MAX_VALUE";
        }
        if (d15 == Double.MIN_NORMAL) {
            return "Double.MIN_NORMAL";
        }
        return Double.toString(d15) + "d";
    }

    public static String formatFloat(float f15) {
        if (Float.isNaN(f15)) {
            return "Float.NaN";
        }
        if (f15 == Float.NEGATIVE_INFINITY) {
            return "Float.NEGATIVE_INFINITY";
        }
        if (f15 == Float.POSITIVE_INFINITY) {
            return "Float.POSITIVE_INFINITY";
        }
        if (f15 == Float.MIN_VALUE) {
            return "Float.MIN_VALUE";
        }
        if (f15 == Float.MAX_VALUE) {
            return "Float.MAX_VALUE";
        }
        if (f15 == Float.MIN_NORMAL) {
            return "Float.MIN_NORMAL";
        }
        return Float.toString(f15) + "f";
    }

    public static String capitalizeFirstChar(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }
}

