/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import java.util.Iterator;
import java.util.List;

public final class InsnList
implements Iterable<InsnNode> {
    private final List<InsnNode> list;

    public InsnList(List<InsnNode> list2) {
        this.list = list2;
    }

    public static void remove(List<InsnNode> list2, InsnNode insn) {
        Iterator<InsnNode> iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            InsnNode next = iterator2.next();
            if (next != insn) continue;
            iterator2.remove();
            return;
        }
    }

    public static void remove(BlockNode block, InsnNode insn) {
        InsnList.remove(block.getInstructions(), insn);
    }

    public static int getIndex(List<InsnNode> list2, InsnNode insn) {
        return InsnList.getIndex(list2, insn, 0);
    }

    public static int getIndex(List<InsnNode> list2, InsnNode insn, int startOffset) {
        int size = list2.size();
        for (int i15 = startOffset; i15 < size; ++i15) {
            if (list2.get(i15) != insn) continue;
            return i15;
        }
        return -1;
    }

    public static boolean contains(List<InsnNode> list2, InsnNode insn) {
        return InsnList.getIndex(list2, insn, 0) != -1;
    }

    public static boolean contains(List<InsnNode> list2, InsnNode insn, int startOffset) {
        return InsnList.getIndex(list2, insn, startOffset) != -1;
    }

    public int getIndex(InsnNode insn) {
        return InsnList.getIndex(this.list, insn);
    }

    public boolean contains(InsnNode insn) {
        return this.getIndex(insn) != -1;
    }

    public void remove(InsnNode insn) {
        InsnList.remove(this.list, insn);
    }

    @Override
    public Iterator<InsnNode> iterator() {
        return this.list.iterator();
    }

    public InsnNode get(int index) {
        return this.list.get(index);
    }

    public int size() {
        return this.list.size();
    }
}

