/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

public class FileSignature {
    private final byte[] signatureBytes;
    private final String fileType;

    public FileSignature(String fileType, String signatureHex) {
        this.fileType = fileType;
        String[] parts = signatureHex.split(" ");
        this.signatureBytes = new byte[parts.length];
        for (int i15 = 0; i15 < parts.length; ++i15) {
            if (parts[i15].length() != 2) {
                throw new RuntimeException(signatureHex);
            }
            if (parts[i15].equals("??")) continue;
            this.signatureBytes[i15] = (byte)Integer.parseInt(parts[i15], 16);
        }
    }

    public static boolean matches(FileSignature sig, byte[] data) {
        if (data.length < sig.signatureBytes.length) {
            return false;
        }
        for (int i15 = 0; i15 < sig.signatureBytes.length; ++i15) {
            byte b15 = sig.signatureBytes[i15];
            if (b15 == data[i15]) continue;
            return false;
        }
        return true;
    }

    public String getFileType() {
        return this.fileType;
    }
}

