/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.rename;

import jadx.api.args.UseSourceNameAsClassNameAlias;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.api.plugins.input.data.attributes.types.SourceFileAttr;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.nodes.RenameReasonAttr;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.BetterName;
import jadx.core.utils.StringUtils;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SourceFileRename
extends AbstractVisitor {
    @Override
    public String getName() {
        return "SourceFileRename";
    }

    @Override
    public void init(RootNode root) throws JadxException {
        String alias;
        UseSourceNameAsClassNameAlias useSourceName = root.getArgs().getUseSourceNameAsClassNameAlias();
        if (useSourceName == UseSourceNameAsClassNameAlias.NEVER) {
            return;
        }
        int repeatLimit = root.getArgs().getSourceNameRepeatLimit();
        if (repeatLimit <= 1) {
            return;
        }
        List<ClassNode> classes = root.getClasses();
        HashMap<String, Integer> aliasUseCount = new HashMap<String, Integer>();
        for (ClassNode cls : classes) {
            aliasUseCount.put(cls.getClassInfo().getShortName(), 1);
        }
        ArrayList<ClsRename> renames = new ArrayList<ClsRename>();
        for (ClassNode cls : classes) {
            int count;
            if (cls.contains(AFlag.DONT_RENAME) || (alias = SourceFileRename.getAliasFromSourceFile(cls)) == null || (count = aliasUseCount.merge(alias, 1, Integer::sum).intValue()) >= repeatLimit) continue;
            renames.add(new ClsRename(cls, alias, count));
        }
        for (ClsRename clsRename : renames) {
            alias = clsRename.getAlias();
            Integer count = (Integer)aliasUseCount.get(alias);
            if (count >= repeatLimit) continue;
            SourceFileRename.applyRename(clsRename.getCls(), clsRename.buildAlias(), useSourceName);
        }
    }

    private static void applyRename(ClassNode cls, String alias, UseSourceNameAsClassNameAlias useSourceName) {
        String currentAlias;
        String betterName;
        if (cls.getClassInfo().hasAlias() && (betterName = SourceFileRename.getBetterName(currentAlias = cls.getAlias(), alias, useSourceName)).equals(currentAlias)) {
            return;
        }
        cls.getClassInfo().changeShortName(alias);
        cls.addAttr(new RenameReasonAttr(cls).append("use source file name"));
    }

    private static String getBetterName(String currentName, String sourceName, UseSourceNameAsClassNameAlias useSourceName) {
        switch (useSourceName) {
            case ALWAYS: {
                return sourceName;
            }
            case IF_BETTER: {
                return BetterName.getBetterClassName(sourceName, currentName);
            }
            case NEVER: {
                return currentName;
            }
        }
        throw new JadxRuntimeException("Unhandled strategy: " + String.valueOf((Object)useSourceName));
    }

    @Nullable
    private static String getAliasFromSourceFile(ClassNode cls) {
        SourceFileAttr sourceFileAttr = cls.get(JadxAttrType.SOURCE_FILE);
        if (sourceFileAttr == null) {
            return null;
        }
        if (cls.getClassInfo().isInner()) {
            return null;
        }
        String name = sourceFileAttr.getFileName();
        name = StringUtils.removeSuffix(name, ".java");
        if (!NameMapper.isValidAndPrintable(name = StringUtils.removeSuffix(name, ".kt"))) {
            return null;
        }
        if (name.equals(cls.getName())) {
            return null;
        }
        return name;
    }

    private static final class ClsRename {
        private final ClassNode cls;
        private final String alias;
        private final int suffix;

        private ClsRename(ClassNode cls, String alias, int suffix) {
            this.cls = cls;
            this.alias = alias;
            this.suffix = suffix;
        }

        public ClassNode getCls() {
            return this.cls;
        }

        public String getAlias() {
            return this.alias;
        }

        public int getSuffix() {
            return this.suffix;
        }

        public String buildAlias() {
            return this.suffix < 2 ? this.alias : this.alias + this.suffix;
        }

        public String toString() {
            return "ClsRename{" + String.valueOf(this.cls) + " -> '" + this.alias + this.suffix + "'}";
        }
    }
}

