/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.visitors.regions.IRegionIterativeVisitor;
import jadx.core.dex.visitors.regions.IRegionVisitor;
import jadx.core.utils.exceptions.JadxOverflowException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.Iterator;

public class DepthRegionTraversal {
    private static final int ITERATIVE_LIMIT_MULTIPLIER = 5;

    private DepthRegionTraversal() {
    }

    public static void traverse(MethodNode mth, IRegionVisitor visitor2) {
        DepthRegionTraversal.traverseInternal(mth, visitor2, mth.getRegion());
    }

    public static void traverse(MethodNode mth, IContainer container, IRegionVisitor visitor2) {
        DepthRegionTraversal.traverseInternal(mth, visitor2, container);
    }

    public static void traverseIterative(MethodNode mth, IRegionIterativeVisitor visitor2) {
        boolean repeat;
        int k15 = 0;
        int limit = 5 * mth.getBasicBlocks().size();
        do {
            repeat = DepthRegionTraversal.traverseIterativeStepInternal(mth, visitor2, mth.getRegion());
            if (k15++ <= limit) continue;
            throw new JadxRuntimeException("Iterative traversal limit reached: limit: " + limit + ", visitor: " + visitor2.getClass().getName() + ", blocks count: " + mth.getBasicBlocks().size());
        } while (repeat);
    }

    public static void traverseIncludingExcHandlers(MethodNode mth, IRegionIterativeVisitor visitor2) {
        boolean repeat;
        int k15 = 0;
        int limit = 5 * mth.getBasicBlocks().size();
        do {
            if (!(repeat = DepthRegionTraversal.traverseIterativeStepInternal(mth, visitor2, mth.getRegion()))) {
                ExceptionHandler h15;
                Iterator<ExceptionHandler> iterator2 = mth.getExceptionHandlers().iterator();
                while (iterator2.hasNext() && !(repeat = DepthRegionTraversal.traverseIterativeStepInternal(mth, visitor2, (h15 = iterator2.next()).getHandlerRegion()))) {
                }
            }
            if (k15++ <= limit) continue;
            throw new JadxRuntimeException("Iterative traversal limit reached: limit: " + limit + ", visitor: " + visitor2.getClass().getName() + ", blocks count: " + mth.getBasicBlocks().size());
        } while (repeat);
    }

    private static void traverseInternal(MethodNode mth, IRegionVisitor visitor2, IContainer container) {
        if (container instanceof IBlock) {
            visitor2.processBlock(mth, (IBlock)container);
        } else if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            if (visitor2.enterRegion(mth, region)) {
                region.getSubBlocks().forEach(subCont -> DepthRegionTraversal.traverseInternal(mth, visitor2, subCont));
            }
            visitor2.leaveRegion(mth, region);
        }
    }

    private static boolean traverseIterativeStepInternal(MethodNode mth, IRegionIterativeVisitor visitor2, IContainer container) {
        if (container instanceof IRegion) {
            IRegion region = (IRegion)container;
            if (visitor2.visitRegion(mth, region)) {
                return true;
            }
            for (IContainer subCont : region.getSubBlocks()) {
                try {
                    if (!DepthRegionTraversal.traverseIterativeStepInternal(mth, visitor2, subCont)) continue;
                    return true;
                }
                catch (StackOverflowError overflow) {
                    throw new JadxOverflowException("Region traversal failed: Recursive call in traverseIterativeStepInternal method");
                }
            }
        }
        return false;
    }
}

