/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.finaly;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.AttrNode;
import jadx.core.dex.attributes.nodes.RegDebugInfoAttr;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.TryCatchBlockAttr;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.ConstInlineVisitor;
import jadx.core.dex.visitors.DepthTraversal;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.finaly.FinallyExtractInfo;
import jadx.core.dex.visitors.finaly.InsnsSlice;
import jadx.core.dex.visitors.ssa.SSATransform;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnList;
import jadx.core.utils.ListUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.blocks.BlockPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JadxVisitor(name="MarkFinallyVisitor", desc="Search and mark duplicate code generated for finally block", runAfter={SSATransform.class}, runBefore={ConstInlineVisitor.class})
public class MarkFinallyVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(MarkFinallyVisitor.class);

    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode() || mth.isNoExceptionHandlers()) {
            return;
        }
        try {
            boolean applied = false;
            List tryBlocks = mth.getAll(AType.TRY_BLOCKS_LIST);
            for (TryCatchBlockAttr tryBlock : tryBlocks) {
                applied |= MarkFinallyVisitor.processTryBlock(mth, tryBlock);
            }
            if (applied) {
                mth.clearExceptionHandlers();
                ArrayList clearedTryBlocks = new ArrayList(tryBlocks);
                if (clearedTryBlocks.removeIf(tb5 -> tb5.isMerged() || tb5.getHandlers().isEmpty())) {
                    mth.remove(AType.TRY_BLOCKS_LIST);
                    mth.addAttr(AType.TRY_BLOCKS_LIST, clearedTryBlocks);
                }
            }
        }
        catch (Exception e15) {
            mth.addWarnComment("Undo finally extract visitor", e15);
            MarkFinallyVisitor.undoFinallyVisitor(mth);
        }
    }

    private static boolean processTryBlock(MethodNode mth, TryCatchBlockAttr tryBlock) {
        if (tryBlock.isMerged()) {
            return false;
        }
        ExceptionHandler allHandler = null;
        AttrNode reThrowInsn = null;
        for (ExceptionHandler excHandler : tryBlock.getHandlers()) {
            if (!excHandler.isCatchAll()) continue;
            allHandler = excHandler;
            for (BlockNode excBlock : excHandler.getBlocks()) {
                InsnNode lastInsn = BlockUtils.getLastInsn(excBlock);
                if (lastInsn == null || lastInsn.getType() != InsnType.THROW) continue;
                reThrowInsn = BlockUtils.getLastInsn(excBlock);
            }
        }
        if (allHandler != null && reThrowInsn != null && MarkFinallyVisitor.extractFinally(mth, tryBlock, allHandler)) {
            reThrowInsn.add(AFlag.DONT_GENERATE);
            return true;
        }
        return false;
    }

    private static boolean extractFinally(MethodNode mth, TryCatchBlockAttr tryBlock, ExceptionHandler allHandler) {
        boolean mergeInnerTryBlocks;
        List<ExceptionHandler> handlers;
        boolean hasInnerBlocks;
        BlockNode handlerBlock = allHandler.getHandlerBlock();
        ArrayList<BlockNode> handlerBlocks = new ArrayList<BlockNode>(BlockUtils.collectBlocksDominatedByWithExcHandlers(mth, handlerBlock, handlerBlock));
        handlerBlocks.remove(handlerBlock);
        MarkFinallyVisitor.cutPathEnds(mth, handlerBlocks);
        if (handlerBlocks.isEmpty() || BlockUtils.isAllBlocksEmpty(handlerBlocks)) {
            allHandler.getTryBlock().removeHandler(allHandler);
            return true;
        }
        BlockNode startBlock = Utils.getOne(handlerBlock.getCleanSuccessors());
        FinallyExtractInfo extractInfo = new FinallyExtractInfo(mth, allHandler, startBlock, handlerBlocks);
        boolean bl4 = hasInnerBlocks = !tryBlock.getInnerTryBlocks().isEmpty();
        if (hasInnerBlocks) {
            handlers = new ArrayList<ExceptionHandler>(tryBlock.getHandlers());
            for (TryCatchBlockAttr innerTryBlock : tryBlock.getInnerTryBlocks()) {
                handlers.addAll(innerTryBlock.getHandlers());
            }
        } else {
            handlers = tryBlock.getHandlers();
        }
        if (handlers.isEmpty()) {
            return false;
        }
        for (ExceptionHandler otherHandler : handlers) {
            if (otherHandler == allHandler) continue;
            for (BlockNode checkBlock : otherHandler.getBlocks()) {
                if (MarkFinallyVisitor.searchDuplicateInsns(checkBlock, extractInfo)) break;
                extractInfo.getFinallyInsnsSlice().resetIncomplete();
            }
        }
        int duplicatesCount = extractInfo.getDuplicateSlices().size();
        if (duplicatesCount == handlers.size() - 1) {
            mergeInnerTryBlocks = hasInnerBlocks;
        } else {
            if (!hasInnerBlocks || duplicatesCount != tryBlock.getHandlers().size() - 1) {
                return false;
            }
            mergeInnerTryBlocks = false;
        }
        List<BlockNode> tryBlocks = allHandler.getTryBlock().getBlocks();
        BlockNode bottomBlock = BlockUtils.getBottomBlock(allHandler.getBlocks());
        if (bottomBlock == null) {
            return false;
        }
        BlockNode bottomFinallyBlock = BlockUtils.followEmptyPath(bottomBlock);
        BlockNode bottom = BlockUtils.getNextBlock(bottomFinallyBlock);
        if (bottom == null) {
            return false;
        }
        boolean found = false;
        List<BlockNode> pathBlocks = MarkFinallyVisitor.getPathStarts(mth, bottom, bottomFinallyBlock);
        block3: for (BlockNode pred : pathBlocks) {
            List<BlockNode> upPath = BlockUtils.collectPredecessors(mth, pred, tryBlocks);
            if (upPath.size() < handlerBlocks.size()) continue;
            for (BlockNode block : upPath) {
                if (MarkFinallyVisitor.searchDuplicateInsns(block, extractInfo)) {
                    found = true;
                    continue block3;
                }
                extractInfo.getFinallyInsnsSlice().resetIncomplete();
            }
        }
        if (!found) {
            return false;
        }
        if (!MarkFinallyVisitor.checkSlices(extractInfo)) {
            mth.addWarnComment("Finally extract failed");
            return false;
        }
        MarkFinallyVisitor.apply(extractInfo);
        allHandler.setFinally(true);
        if (mergeInnerTryBlocks) {
            List<TryCatchBlockAttr> innerTryBlocks = tryBlock.getInnerTryBlocks();
            for (TryCatchBlockAttr innerTryBlock : innerTryBlocks) {
                tryBlock.getHandlers().addAll(innerTryBlock.getHandlers());
                tryBlock.getBlocks().addAll(innerTryBlock.getBlocks());
                innerTryBlock.setMerged(true);
            }
            tryBlock.setBlocks(ListUtils.distinctList(tryBlock.getBlocks()));
            innerTryBlocks.clear();
        }
        return true;
    }

    private static void cutPathEnds(MethodNode mth, List<BlockNode> handlerBlocks) {
        List<BlockNode> throwBlocks = ListUtils.filter(handlerBlocks, b15 -> BlockUtils.checkLastInsnType(b15, InsnType.THROW));
        if (throwBlocks.size() != 1) {
            mth.addDebugComment("Finally have unexpected throw blocks count: " + throwBlocks.size() + ", expect 1");
            return;
        }
        BlockNode throwBlock = throwBlocks.get(0);
        handlerBlocks.remove(throwBlock);
        MarkFinallyVisitor.removeEmptyUpPath(handlerBlocks, throwBlock);
    }

    private static void removeEmptyUpPath(List<BlockNode> handlerBlocks, BlockNode startBlock) {
        for (BlockNode pred : startBlock.getPredecessors()) {
            if (!pred.isEmpty() || !handlerBlocks.remove(pred) || BlockUtils.isBackEdge(pred, startBlock)) continue;
            MarkFinallyVisitor.removeEmptyUpPath(handlerBlocks, pred);
        }
    }

    private static List<BlockNode> getPathStarts(MethodNode mth, BlockNode bottom, BlockNode bottomFinallyBlock) {
        Stream<BlockNode> preds = bottom.getPredecessors().stream().filter(b15 -> b15 != bottomFinallyBlock);
        if (bottom == mth.getExitBlock()) {
            preds = preds.flatMap(r15 -> r15.getPredecessors().stream());
        }
        return preds.collect(Collectors.toList());
    }

    private static boolean checkSlices(FinallyExtractInfo extractInfo) {
        InsnsSlice finallySlice = extractInfo.getFinallyInsnsSlice();
        List<InsnNode> finallyInsnsList = finallySlice.getInsnsList();
        for (InsnsSlice dupSlice : extractInfo.getDuplicateSlices()) {
            List<InsnNode> dupInsnsList = dupSlice.getInsnsList();
            if (dupInsnsList.size() == finallyInsnsList.size()) continue;
            extractInfo.getMth().addDebugComment("Incorrect finally slice size: " + String.valueOf(dupSlice) + ", expected: " + String.valueOf(finallySlice));
            return false;
        }
        for (int i15 = 0; i15 < finallyInsnsList.size(); ++i15) {
            InsnNode finallyInsn = finallyInsnsList.get(i15);
            for (InsnsSlice dupSlice : extractInfo.getDuplicateSlices()) {
                List<InsnNode> insnsList = dupSlice.getInsnsList();
                InsnNode dupInsn = insnsList.get(i15);
                if (finallyInsn.getType() == dupInsn.getType()) continue;
                extractInfo.getMth().addDebugComment("Incorrect finally slice insn: " + String.valueOf(dupInsn) + ", expected: " + String.valueOf(finallyInsn));
                return false;
            }
        }
        return true;
    }

    private static void apply(FinallyExtractInfo extractInfo) {
        MarkFinallyVisitor.markSlice(extractInfo.getFinallyInsnsSlice(), AFlag.FINALLY_INSNS);
        for (InsnsSlice dupSlice : extractInfo.getDuplicateSlices()) {
            MarkFinallyVisitor.markSlice(dupSlice, AFlag.DONT_GENERATE);
        }
        InsnsSlice finallySlice = extractInfo.getFinallyInsnsSlice();
        List<InsnNode> finallyInsnsList = finallySlice.getInsnsList();
        for (int i15 = 0; i15 < finallyInsnsList.size(); ++i15) {
            InsnNode finallyInsn = finallyInsnsList.get(i15);
            for (InsnsSlice dupSlice : extractInfo.getDuplicateSlices()) {
                InsnNode dupInsn = dupSlice.getInsnsList().get(i15);
                MarkFinallyVisitor.copyCodeVars(finallyInsn, dupInsn);
            }
        }
    }

    private static void markSlice(InsnsSlice slice, AFlag flag) {
        List<InsnNode> insnsList = slice.getInsnsList();
        for (InsnNode insn : insnsList) {
            insn.add(flag);
        }
        for (BlockNode block : slice.getBlocks()) {
            boolean allInsnMarked = true;
            for (InsnNode insn : block.getInstructions()) {
                if (insn.contains(flag)) continue;
                allInsnMarked = false;
                break;
            }
            if (!allInsnMarked) continue;
            block.add(flag);
        }
    }

    private static void copyCodeVars(InsnNode fromInsn, InsnNode toInsn) {
        MarkFinallyVisitor.copyCodeVars(fromInsn.getResult(), toInsn.getResult());
        int argsCount = fromInsn.getArgsCount();
        for (int i15 = 0; i15 < argsCount; ++i15) {
            MarkFinallyVisitor.copyCodeVars(fromInsn.getArg(i15), toInsn.getArg(i15));
        }
    }

    private static void copyCodeVars(InsnArg fromArg, InsnArg toArg) {
        if (fromArg == null || toArg == null || !fromArg.isRegister() || !toArg.isRegister()) {
            return;
        }
        SSAVar fromSsaVar = ((RegisterArg)fromArg).getSVar();
        SSAVar toSsaVar = ((RegisterArg)toArg).getSVar();
        toSsaVar.setCodeVar(fromSsaVar.getCodeVar());
    }

    private static boolean searchDuplicateInsns(BlockNode checkBlock, FinallyExtractInfo extractInfo) {
        boolean isNew = extractInfo.getCheckedBlocks().add(checkBlock);
        if (!isNew) {
            return false;
        }
        BlockNode startBlock = extractInfo.getStartBlock();
        InsnsSlice dupSlice = MarkFinallyVisitor.searchFromFirstBlock(checkBlock, startBlock, extractInfo);
        if (dupSlice == null) {
            return false;
        }
        extractInfo.getDuplicateSlices().add(dupSlice);
        return true;
    }

    private static InsnsSlice searchFromFirstBlock(BlockNode dupBlock, BlockNode startBlock, FinallyExtractInfo extractInfo) {
        InsnsSlice dupSlice = MarkFinallyVisitor.isStartBlock(dupBlock, startBlock, extractInfo);
        if (dupSlice == null) {
            return null;
        }
        if (!dupSlice.isComplete()) {
            HashMap<BlockPair, Boolean> checkCache = new HashMap<BlockPair, Boolean>();
            if (MarkFinallyVisitor.checkBlocksTree(dupBlock, startBlock, dupSlice, extractInfo, checkCache)) {
                dupSlice.setComplete(true);
                extractInfo.getFinallyInsnsSlice().setComplete(true);
            } else {
                return null;
            }
        }
        return MarkFinallyVisitor.checkTempSlice(dupSlice);
    }

    @Nullable
    private static InsnsSlice checkTempSlice(InsnsSlice slice) {
        InsnNode insnNode;
        List<InsnNode> insnsList = slice.getInsnsList();
        if (insnsList.isEmpty()) {
            return null;
        }
        if (insnsList.size() == 1 && (insnNode = insnsList.get(0)).getType() == InsnType.IF) {
            return null;
        }
        return slice;
    }

    private static InsnsSlice isStartBlock(BlockNode dupBlock, BlockNode finallyBlock, FinallyExtractInfo extractInfo) {
        boolean complete;
        int endIndex;
        int startPos;
        extractInfo.setCurDupSlice(null);
        List<InsnNode> dupInsns = dupBlock.getInstructions();
        List<InsnNode> finallyInsns = finallyBlock.getInstructions();
        int dupSize = dupInsns.size();
        int finSize = finallyInsns.size();
        if (dupSize < finSize) {
            return null;
        }
        int endPos = 0;
        if (dupSize == finSize) {
            if (!MarkFinallyVisitor.checkInsns(extractInfo, dupInsns, finallyInsns, 0)) {
                return null;
            }
            startPos = 0;
        } else {
            startPos = dupSize - finSize;
            if (!MarkFinallyVisitor.checkInsns(extractInfo, dupInsns, finallyInsns, startPos)) {
                boolean found = false;
                for (int i15 = 1; i15 < startPos; ++i15) {
                    if (!MarkFinallyVisitor.checkInsns(extractInfo, dupInsns, finallyInsns, i15)) continue;
                    startPos = i15;
                    endPos = finSize + i15;
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
            }
        }
        InsnsSlice slice = new InsnsSlice();
        extractInfo.setCurDupSlice(slice);
        if (endPos != 0) {
            endIndex = endPos + 1;
            complete = true;
        } else {
            endIndex = dupSize;
            complete = false;
        }
        for (int i16 = startPos; i16 < endIndex; ++i16) {
            slice.addInsn(dupInsns.get(i16), dupBlock);
        }
        InsnsSlice finallySlice = extractInfo.getFinallyInsnsSlice();
        if (finallySlice.isComplete()) {
            if (finallySlice.getInsnsList().size() != slice.getInsnsList().size()) {
                extractInfo.getMth().addDebugComment("Another duplicated slice has different insns count: " + String.valueOf(slice) + ", finally: " + String.valueOf(finallySlice));
                return null;
            }
        } else {
            for (InsnNode finallyInsn : finallyInsns) {
                finallySlice.addInsn(finallyInsn, finallyBlock);
            }
        }
        if (complete) {
            slice.setComplete(true);
            finallySlice.setComplete(true);
        }
        return slice;
    }

    private static boolean checkInsns(FinallyExtractInfo extractInfo, List<InsnNode> dupInsns, List<InsnNode> finallyInsns, int delta) {
        extractInfo.setCurDupInsns(dupInsns, delta);
        for (int i15 = finallyInsns.size() - 1; i15 >= 0; --i15) {
            InsnNode startInsn = finallyInsns.get(i15);
            InsnNode dupInsn = dupInsns.get(delta + i15);
            if (MarkFinallyVisitor.sameInsns(extractInfo, dupInsn, startInsn)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkBlocksTree(BlockNode dupBlock, BlockNode finallyBlock, InsnsSlice dupSlice, FinallyExtractInfo extractInfo, Map<BlockPair, Boolean> checksCache) {
        boolean same;
        BlockPair checkBlocks = new BlockPair(dupBlock, finallyBlock);
        Boolean checked = checksCache.get(checkBlocks);
        if (checked != null) {
            return checked;
        }
        InsnsSlice finallySlice = extractInfo.getFinallyInsnsSlice();
        List<BlockNode> finallyCS = MarkFinallyVisitor.getSuccessorsWithoutLoop(finallyBlock);
        List<BlockNode> dupCS = MarkFinallyVisitor.getSuccessorsWithoutLoop(dupBlock);
        if (finallyCS.size() == dupCS.size()) {
            same = true;
            for (int i15 = 0; i15 < finallyCS.size(); ++i15) {
                BlockNode finSBlock = finallyCS.get(i15);
                BlockNode dupSBlock = dupCS.get(i15);
                if (!extractInfo.getAllHandlerBlocks().contains(finSBlock)) continue;
                if (!MarkFinallyVisitor.compareBlocks(dupSBlock, finSBlock, dupSlice, extractInfo)) {
                    same = false;
                    break;
                }
                if (!MarkFinallyVisitor.checkBlocksTree(dupSBlock, finSBlock, dupSlice, extractInfo, checksCache)) {
                    same = false;
                    break;
                }
                dupSlice.addBlock(dupSBlock);
                finallySlice.addBlock(finSBlock);
            }
        } else {
            same = true;
        }
        checksCache.put(checkBlocks, same);
        return same;
    }

    private static List<BlockNode> getSuccessorsWithoutLoop(BlockNode block) {
        if (block.contains(AFlag.LOOP_END)) {
            return block.getCleanSuccessors();
        }
        return block.getSuccessors();
    }

    private static boolean compareBlocks(BlockNode dupBlock, BlockNode finallyBlock, InsnsSlice dupSlice, FinallyExtractInfo extractInfo) {
        List<InsnNode> dupInsns = dupBlock.getInstructions();
        List<InsnNode> finallyInsns = finallyBlock.getInstructions();
        int dupInsnCount = dupInsns.size();
        int finallyInsnCount = finallyInsns.size();
        if (finallyInsnCount == 0) {
            return dupInsnCount == 0;
        }
        if (dupInsnCount < finallyInsnCount) {
            return false;
        }
        extractInfo.setCurDupInsns(dupInsns, 0);
        for (int i15 = 0; i15 < finallyInsnCount; ++i15) {
            if (MarkFinallyVisitor.sameInsns(extractInfo, dupInsns.get(i15), finallyInsns.get(i15))) continue;
            return false;
        }
        if (dupInsnCount > finallyInsnCount) {
            dupSlice.addInsns(dupBlock, 0, finallyInsnCount);
            dupSlice.setComplete(true);
            InsnsSlice finallyInsnsSlice = extractInfo.getFinallyInsnsSlice();
            finallyInsnsSlice.addBlock(finallyBlock);
            finallyInsnsSlice.setComplete(true);
        }
        return true;
    }

    private static boolean sameInsns(FinallyExtractInfo extractInfo, InsnNode dupInsn, InsnNode fInsn) {
        if (!dupInsn.isSame(fInsn)) {
            return false;
        }
        for (int i15 = 0; i15 < dupInsn.getArgsCount(); ++i15) {
            InsnArg fArg;
            InsnArg dupArg = dupInsn.getArg(i15);
            if (MarkFinallyVisitor.isSameArgs(extractInfo, dupArg, fArg = fInsn.getArg(i15))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameArgs(FinallyExtractInfo extractInfo, InsnArg dupArg, InsnArg fArg) {
        RegisterArg fReg;
        RegisterArg dupReg;
        boolean isReg = dupArg.isRegister();
        if (isReg != fArg.isRegister()) {
            return false;
        }
        if (isReg && !(dupReg = (RegisterArg)dupArg).sameCodeVar(fReg = (RegisterArg)fArg) && !MarkFinallyVisitor.sameDebugInfo(dupReg, fReg) && MarkFinallyVisitor.assignedOutsideHandler(extractInfo, dupReg, fReg) && MarkFinallyVisitor.assignInsnDifferent(dupReg, fReg)) {
            return false;
        }
        boolean remConst = dupArg.isConst();
        if (remConst != fArg.isConst()) {
            return false;
        }
        return !remConst || dupArg.isSameConst(fArg);
    }

    private static boolean sameDebugInfo(RegisterArg dupReg, RegisterArg fReg) {
        RegDebugInfoAttr fDbgInfo = fReg.get(AType.REG_DEBUG_INFO);
        RegDebugInfoAttr dupDbgInfo = dupReg.get(AType.REG_DEBUG_INFO);
        if (fDbgInfo == null || dupDbgInfo == null) {
            return false;
        }
        return dupDbgInfo.equals(fDbgInfo);
    }

    private static boolean assignInsnDifferent(RegisterArg dupReg, RegisterArg fReg) {
        InsnNode assignInsn = fReg.getAssignInsn();
        InsnNode dupAssign = dupReg.getAssignInsn();
        if (assignInsn == null || dupAssign == null) {
            return true;
        }
        if (!assignInsn.isSame(dupAssign)) {
            return true;
        }
        if (assignInsn.isConstInsn() && dupAssign.isConstInsn()) {
            return !assignInsn.isDeepEquals(dupAssign);
        }
        return false;
    }

    private static boolean assignedOutsideHandler(FinallyExtractInfo extractInfo, RegisterArg dupReg, RegisterArg fReg) {
        if (InsnList.contains(extractInfo.getFinallyInsnsSlice().getInsnsList(), fReg.getAssignInsn())) {
            return false;
        }
        InsnNode dupAssign = dupReg.getAssignInsn();
        InsnsSlice curDupSlice = extractInfo.getCurDupSlice();
        if (curDupSlice != null && InsnList.contains(curDupSlice.getInsnsList(), dupAssign)) {
            return false;
        }
        List<InsnNode> curDupInsns = extractInfo.getCurDupInsns();
        return !Utils.notEmpty(curDupInsns) || !InsnList.contains(curDupInsns, dupAssign, extractInfo.getCurDupInsnsOffset());
    }

    private static void undoFinallyVisitor(MethodNode mth) {
        try {
            mth.unload();
            mth.load();
            for (IDexTreeVisitor visitor2 : mth.root().getPasses()) {
                if (visitor2 instanceof MarkFinallyVisitor) break;
                DepthTraversal.visit(visitor2, mth);
            }
        }
        catch (Exception e15) {
            mth.addError("Undo finally extract failed", e15);
        }
    }
}

