/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.deobf.NameMapper;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.nodes.parser.SignatureParser;
import jadx.core.dex.nodes.utils.TypeUtils;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.typeinference.TypeCompareEnum;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class SignatureProcessor
extends AbstractVisitor {
    private RootNode root;

    @Override
    public void init(RootNode root) {
        this.root = root;
    }

    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        this.parseClassSignature(cls);
        for (FieldNode field : cls.getFields()) {
            this.parseFieldSignature(field);
        }
        for (MethodNode mth : cls.getMethods()) {
            this.parseMethodSignature(mth);
        }
        return true;
    }

    private void parseClassSignature(ClassNode cls) {
        SignatureParser sp4 = SignatureParser.fromNode(cls);
        if (sp4 == null) {
            return;
        }
        try {
            List<ArgType> generics = sp4.consumeGenericTypeParameters();
            ArgType superClass = this.processSuperType(cls, sp4.consumeType());
            List<ArgType> interfaces = this.processInterfaces(cls, sp4.consumeTypeList());
            List<ArgType> resultGenerics = SignatureProcessor.fixTypeParamDeclarations(cls, generics, superClass, interfaces);
            cls.updateGenericClsData(resultGenerics, superClass, interfaces);
        }
        catch (Exception e15) {
            cls.addWarnComment("Failed to parse class signature: " + sp4.getSignature(), e15);
        }
    }

    private ArgType processSuperType(ClassNode cls, ArgType parsedType) {
        ArgType superType = cls.getSuperClass();
        if (Objects.equals(parsedType.getObject(), cls.getClassInfo().getType().getObject())) {
            cls.addWarnComment("Incorrect class signature: super class is equals to this class");
            return superType;
        }
        return this.bestClsType(cls, parsedType, superType);
    }

    private List<ArgType> processInterfaces(ClassNode cls, List<ArgType> parsedTypes) {
        List<ArgType> interfaces = cls.getInterfaces();
        if (parsedTypes.isEmpty()) {
            return interfaces;
        }
        int parsedCount = parsedTypes.size();
        int interfacesCount = interfaces.size();
        ArrayList<ArgType> result = new ArrayList<ArgType>(interfacesCount);
        int count = Math.min(interfacesCount, parsedCount);
        for (int i15 = 0; i15 < interfacesCount; ++i15) {
            if (i15 < count) {
                result.add(this.bestClsType(cls, parsedTypes.get(i15), interfaces.get(i15)));
                continue;
            }
            result.add(interfaces.get(i15));
        }
        if (interfacesCount < parsedCount) {
            cls.addWarnComment("Unexpected interfaces in signature: " + String.valueOf(parsedTypes.subList(interfacesCount, parsedCount)));
        }
        return result;
    }

    private static List<ArgType> fixTypeParamDeclarations(ClassNode cls, List<ArgType> generics, ArgType superClass, List<ArgType> interfaces) {
        List<ArgType> knownTypeParams;
        if (interfaces.isEmpty() && superClass.equals(ArgType.OBJECT)) {
            return generics;
        }
        HashSet typeParams = new HashSet();
        superClass.visitTypes(t15 -> SignatureProcessor.addGenericType(typeParams, t15));
        interfaces.forEach(i15 -> i15.visitTypes(t15 -> SignatureProcessor.addGenericType(typeParams, t15)));
        if (typeParams.isEmpty()) {
            return generics;
        }
        if (cls.isInner()) {
            knownTypeParams = new ArrayList<ArgType>(generics);
            cls.visitParentClasses(p15 -> knownTypeParams.addAll(p15.getGenericTypeParameters()));
        } else {
            knownTypeParams = generics;
        }
        for (ArgType declTypeParam : knownTypeParams) {
            typeParams.remove(declTypeParam.getObject());
        }
        if (typeParams.isEmpty()) {
            return generics;
        }
        cls.addInfoComment("Add missing generic type declarations: " + String.valueOf(typeParams));
        ArrayList<ArgType> fixedGenerics = new ArrayList<ArgType>(generics.size() + typeParams.size());
        fixedGenerics.addAll(generics);
        typeParams.stream().sorted().map(ArgType::genericType).forEach(fixedGenerics::add);
        return fixedGenerics;
    }

    @Nullable
    private static Object addGenericType(Set<String> usedTypeParameters, ArgType t15) {
        if (t15.isGenericType()) {
            usedTypeParameters.add(t15.getObject());
        }
        return null;
    }

    private ArgType bestClsType(ClassNode cls, ArgType candidateType, ArgType currentType) {
        if (this.validateClsType(cls, candidateType)) {
            return candidateType;
        }
        return currentType;
    }

    private boolean validateClsType(ClassNode cls, ArgType candidateType) {
        if (candidateType == null) {
            return false;
        }
        if (!candidateType.isObject()) {
            cls.addWarnComment("Incorrect class signature, class is not an object: " + String.valueOf(candidateType));
            return false;
        }
        return true;
    }

    private void parseFieldSignature(FieldNode field) {
        SignatureParser sp4 = SignatureParser.fromNode(field);
        if (sp4 == null) {
            return;
        }
        ClassNode cls = field.getParentClass();
        try {
            ArgType signatureType = sp4.consumeType();
            if (signatureType == null) {
                return;
            }
            if (!this.validateInnerType(signatureType)) {
                field.addWarnComment("Incorrect inner types in field signature: " + sp4.getSignature());
                return;
            }
            ArgType type = this.root.getTypeUtils().expandTypeVariables(cls, signatureType);
            if (!this.validateParsedType(type, field.getType())) {
                field.addInfoComment("Incorrect field signature: " + sp4.getSignature());
                return;
            }
            field.updateType(type);
        }
        catch (Exception e15) {
            cls.addWarnComment("Field signature parse error: " + field.getName(), e15);
        }
    }

    private void parseMethodSignature(MethodNode mth) {
        SignatureParser sp4 = SignatureParser.fromNode(mth);
        if (sp4 == null) {
            return;
        }
        try {
            List<ArgType> typeParameters = sp4.consumeGenericTypeParameters();
            List<ArgType> parsedArgTypes = sp4.consumeMethodArgs(mth.getMethodInfo().getArgsCount());
            ArgType parsedRetType = sp4.consumeType();
            if (!this.validateInnerType(parsedRetType) || !this.validateInnerType(parsedArgTypes)) {
                mth.addWarnComment("Incorrect inner types in method signature: " + sp4.getSignature());
                return;
            }
            mth.updateTypeParameters(typeParameters);
            TypeUtils typeUtils = this.root.getTypeUtils();
            ArgType retType = typeUtils.expandTypeVariables(mth, parsedRetType);
            List<ArgType> argTypes = Utils.collectionMap(parsedArgTypes, t15 -> typeUtils.expandTypeVariables(mth, (ArgType)t15));
            if (!this.validateAndApplyTypes(mth, sp4, retType, argTypes)) {
                mth.updateTypeParameters(Collections.emptyList());
            }
        }
        catch (Exception e15) {
            mth.addWarnComment("Failed to parse method signature: " + sp4.getSignature(), e15);
        }
    }

    private boolean validateAndApplyTypes(MethodNode mth, SignatureParser sp4, ArgType retType, List<ArgType> argTypes) {
        try {
            if (!this.validateParsedType(retType, mth.getMethodInfo().getReturnType())) {
                mth.addWarnComment("Incorrect return type in method signature: " + sp4.getSignature());
                return false;
            }
            List<ArgType> checkedArgTypes = this.checkArgTypes(mth, sp4, argTypes);
            if (checkedArgTypes == null) {
                return false;
            }
            mth.updateTypes(Collections.unmodifiableList(checkedArgTypes), retType);
            return true;
        }
        catch (Exception e15) {
            mth.addWarnComment("Type validation failed for signature: " + sp4.getSignature(), e15);
            return false;
        }
    }

    private List<ArgType> checkArgTypes(MethodNode mth, SignatureParser sp4, List<ArgType> parsedArgTypes) {
        MethodInfo mthInfo = mth.getMethodInfo();
        List<ArgType> mthArgTypes = mthInfo.getArgumentsTypes();
        int len = parsedArgTypes.size();
        if (len != mthArgTypes.size()) {
            if (mth.getParentClass().getAccessFlags().isEnum()) {
                return null;
            }
            if (mthInfo.isConstructor() && !mthArgTypes.isEmpty() && !parsedArgTypes.isEmpty()) {
                ArrayList<ArgType> newArgTypes = new ArrayList<ArgType>(parsedArgTypes);
                newArgTypes.add(0, mthArgTypes.get(0));
                if (newArgTypes.size() == mthArgTypes.size()) {
                    return newArgTypes;
                }
            }
            mth.addDebugComment("Incorrect args count in method signature: " + sp4.getSignature());
            return null;
        }
        for (int i15 = 0; i15 < len; ++i15) {
            ArgType mthArgType;
            ArgType parsedType = parsedArgTypes.get(i15);
            if (this.validateParsedType(parsedType, mthArgType = mthArgTypes.get(i15))) continue;
            mth.addWarnComment("Incorrect types in method signature: " + sp4.getSignature());
            return null;
        }
        return parsedArgTypes;
    }

    private boolean validateParsedType(ArgType parsedType, ArgType currentType) {
        TypeCompareEnum result = this.root.getTypeCompare().compareTypes(parsedType, currentType);
        if (result == TypeCompareEnum.UNKNOWN && parsedType.isObject() && !this.validateFullClsName(parsedType.getObject())) {
            return false;
        }
        return result != TypeCompareEnum.CONFLICT;
    }

    private boolean validateFullClsName(String fullClsName) {
        if (!NameMapper.isValidFullIdentifier(fullClsName)) {
            return false;
        }
        if (fullClsName.indexOf(46) > 0) {
            for (String namePart : fullClsName.split("\\.")) {
                if (NameMapper.isValidIdentifier(namePart)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateInnerType(List<ArgType> types) {
        for (ArgType type : types) {
            if (this.validateInnerType(type)) continue;
            return false;
        }
        return true;
    }

    private boolean validateInnerType(ArgType type) {
        ArgType innerType = type.getInnerType();
        if (innerType == null) {
            return true;
        }
        ArgType outerType = type.getOuterType();
        ClassNode outerCls = this.root.resolveClass(outerType);
        if (outerCls == null) {
            return true;
        }
        String innerObj = innerType.getOuterType() != null ? innerType.getOuterType().getObject() : innerType.getObject();
        if (!innerObj.contains(".")) {
            for (ClassNode innerClass : outerCls.getInnerClasses()) {
                if (!innerClass.getShortName().equals(innerObj)) continue;
                return true;
            }
            return false;
        }
        ClassNode innerCls = this.root.resolveClass(innerObj);
        if (innerCls == null) {
            return false;
        }
        if (!innerCls.getParentClass().equals(outerCls)) {
            outerCls.addInnerClass(innerCls);
            innerCls.getClassInfo().convertToInner(outerCls);
        }
        return this.validateInnerType(innerType);
    }

    @Override
    public String getName() {
        return "SignatureProcessor";
    }
}

