/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.api.plugins.input.data.ICallSite;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.insns.InsnData;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.JadxError;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.invokedynamic.CustomLambdaCall;
import jadx.core.dex.instructions.invokedynamic.CustomRawCall;
import jadx.core.dex.instructions.invokedynamic.CustomStringConcat;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.input.InsnDataUtils;
import java.util.List;

public class InvokeCustomBuilder {
    /*
     * Loose catch block
     */
    public static InsnNode build(MethodNode mth, InsnData insn, boolean isRange) {
        List<EncodedValue> values2;
        block7: {
            ICallSite callSite = InsnDataUtils.getCallSite(insn);
            if (callSite == null) {
                throw new JadxRuntimeException("Failed to get call site for insn: " + String.valueOf(insn));
            }
            callSite.load();
            values2 = callSite.getValues();
            if (CustomLambdaCall.isLambdaInvoke(values2)) {
                return CustomLambdaCall.buildLambdaMethodCall(mth, insn, isRange, values2);
            }
            if (!CustomStringConcat.isStringConcat(values2)) break block7;
            return CustomStringConcat.buildStringConcat(insn, isRange, values2);
            {
                catch (Exception e15) {
                    throw new JadxRuntimeException("'invoke-custom' instruction processing error: " + e15.getMessage(), e15);
                }
            }
        }
        try {
            return CustomRawCall.build(mth, insn, isRange, values2);
        }
        catch (Exception e16) {
            mth.addWarn("Failed to decode invoke-custom: \n" + Utils.listToString(values2, "\n") + ",\n exception: " + Utils.getStackTrace(e16));
            InsnNode nop = new InsnNode(InsnType.NOP, 0);
            nop.add(AFlag.SYNTHETIC);
            nop.addAttr(AType.JADX_ERROR, new JadxError("Failed to decode invoke-custom: " + String.valueOf(values2), e16));
            return nop;
        }
    }
}

