/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.codegen;

import jadx.core.codegen.ClassGen;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.nodes.LoopLabelAttr;
import jadx.core.dex.instructions.args.CodeVar;
import jadx.core.dex.instructions.args.NamedArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NameGen {
    private final MethodNode mth;
    private final boolean fallback;
    private final Set<String> varNames = new HashSet<String>();

    public NameGen(MethodNode mth, ClassGen classGen) {
        this.mth = mth;
        this.fallback = classGen.isFallbackMode();
        NameGen outerNameGen = classGen.getOuterNameGen();
        if (outerNameGen != null) {
            this.inheritUsedNames(outerNameGen);
        }
        this.addNamesUsedInClass();
    }

    public void inheritUsedNames(NameGen otherNameGen) {
        this.varNames.addAll(otherNameGen.varNames);
    }

    private void addNamesUsedInClass() {
        ClassNode parentClass = this.mth.getParentClass();
        for (FieldNode field : parentClass.getFields()) {
            if (!field.isStatic()) continue;
            this.varNames.add(field.getAlias());
        }
        for (ClassNode innerClass : parentClass.getInnerClasses()) {
            this.varNames.add(innerClass.getClassInfo().getAliasShortName());
        }
        this.varNames.addAll(this.mth.root().getCacheStorage().getRootPkgs());
    }

    public String assignArg(CodeVar var) {
        if (this.fallback) {
            return this.getFallbackName(var);
        }
        if (var.isThis()) {
            return "this";
        }
        String name = this.getUniqueVarName(this.makeArgName(var));
        var.setName(name);
        return name;
    }

    public String assignNamedArg(NamedArg arg) {
        String name = arg.getName();
        if (this.fallback) {
            return name;
        }
        String uniqName = this.getUniqueVarName(name);
        arg.setName(uniqName);
        return uniqName;
    }

    public String useArg(RegisterArg arg) {
        String name = arg.getName();
        if (name == null || this.fallback) {
            return this.getFallbackName(arg);
        }
        return name;
    }

    public String getLoopLabel(LoopLabelAttr attr) {
        String name = "loop" + attr.getLoop().getId();
        this.varNames.add(name);
        return name;
    }

    private String getUniqueVarName(String name) {
        Object r15 = name;
        int i15 = 2;
        while (this.varNames.contains(r15)) {
            r15 = name + i15;
            ++i15;
        }
        this.varNames.add((String)r15);
        return r15;
    }

    private String makeArgName(CodeVar var) {
        String name = var.getName();
        if (NameMapper.isValidAndPrintable(name)) {
            return name;
        }
        return this.getFallbackName(var);
    }

    private String getFallbackName(CodeVar var) {
        List<SSAVar> ssaVars = var.getSsaVars();
        if (ssaVars.isEmpty()) {
            return "v";
        }
        return this.getFallbackName(ssaVars.get(0).getAssign());
    }

    private String getFallbackName(RegisterArg arg) {
        return "r" + arg.getRegNum();
    }
}

