/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.api.JadxDecompiler;
import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.api.impl.SimpleCodeInfo;
import jadx.api.plugins.CustomResourcesLoader;
import jadx.api.plugins.resources.IResContainerFactory;
import jadx.api.plugins.resources.IResTableParserProvider;
import jadx.api.plugins.resources.IResourcesLoader;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.Utils;
import jadx.core.utils.android.Res9patchStreamDecoder;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import jadx.core.xmlgen.BinaryXMLParser;
import jadx.core.xmlgen.IResTableParser;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.ResTableBinaryParserProvider;
import jadx.zip.IZipEntry;
import jadx.zip.ZipContent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourcesLoader
implements IResourcesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesLoader.class);
    private final JadxDecompiler decompiler;
    private final List<IResTableParserProvider> resTableParserProviders = new ArrayList<IResTableParserProvider>();
    private final List<IResContainerFactory> resContainerFactories = new ArrayList<IResContainerFactory>();
    private BinaryXMLParser binaryXmlParser;

    ResourcesLoader(JadxDecompiler decompiler) {
        this.decompiler = decompiler;
        this.resTableParserProviders.add(new ResTableBinaryParserProvider());
    }

    List<ResourceFile> load(RootNode root) {
        this.init(root);
        List<File> inputFiles = this.decompiler.getArgs().getInputFiles();
        ArrayList<ResourceFile> list2 = new ArrayList<ResourceFile>(inputFiles.size());
        for (File file2 : inputFiles) {
            this.loadFile(list2, file2);
        }
        return list2;
    }

    private void init(RootNode root) {
        for (IResTableParserProvider resTableParserProvider : this.resTableParserProviders) {
            try {
                resTableParserProvider.init(root);
            }
            catch (Exception e15) {
                throw new JadxRuntimeException("Failed to init res table provider: " + String.valueOf(resTableParserProvider));
            }
        }
        for (IResContainerFactory resContainerFactory : this.resContainerFactories) {
            try {
                resContainerFactory.init(root);
            }
            catch (Exception e16) {
                throw new JadxRuntimeException("Failed to init res container factory: " + String.valueOf(resContainerFactory));
            }
        }
    }

    @Override
    public void addResContainerFactory(IResContainerFactory resContainerFactory) {
        this.resContainerFactories.add(resContainerFactory);
    }

    @Override
    public void addResTableParserProvider(IResTableParserProvider resTableParserProvider) {
        this.resTableParserProviders.add(resTableParserProvider);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T decodeStream(ResourceFile rf5, ResourceDecoder<T> decoder) throws JadxException {
        try {
            IZipEntry zipEntry = rf5.getZipEntry();
            if (zipEntry != null) {
                try (InputStream inputStream = zipEntry.getInputStream();){
                    T t15 = decoder.decode(zipEntry.getUncompressedSize(), inputStream);
                    return t15;
                }
            }
            File file2 = new File(rf5.getOriginalName());
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file2));){
                T t16 = decoder.decode(file2.length(), inputStream);
                return t16;
            }
        }
        catch (Exception e15) {
            throw new JadxException("Error decode: " + rf5.getOriginalName(), e15);
        }
    }

    static ResContainer loadContent(JadxDecompiler jadxRef, ResourceFile rf5) {
        try {
            ResourcesLoader resLoader = jadxRef.getResourcesLoader();
            return ResourcesLoader.decodeStream(rf5, (size, is4) -> resLoader.loadContent(rf5, is4));
        }
        catch (JadxException e15) {
            LOG.error("Decode error", e15);
            ICodeWriter cw4 = jadxRef.getRoot().makeCodeWriter();
            cw4.add("Error decode ").add(rf5.getType().toString().toLowerCase());
            Utils.appendStackTrace(cw4, e15.getCause());
            return ResContainer.textResource(rf5.getDeobfName(), cw4.finish());
        }
    }

    private ResContainer loadContent(ResourceFile resFile, InputStream inputStream) throws IOException {
        for (IResContainerFactory customFactory : this.resContainerFactories) {
            ResContainer resContainer = customFactory.create(resFile, inputStream);
            if (resContainer == null) continue;
            return resContainer;
        }
        switch (resFile.getType()) {
            case MANIFEST: 
            case XML: {
                ICodeInfo content = this.loadBinaryXmlParser().parse(inputStream);
                return ResContainer.textResource(resFile.getDeobfName(), content);
            }
            case ARSC: {
                return this.decodeTable(resFile, inputStream).decodeFiles();
            }
            case IMG: {
                return ResourcesLoader.decodeImage(resFile, inputStream);
            }
        }
        return ResContainer.resourceFileLink(resFile);
    }

    public IResTableParser decodeTable(ResourceFile resFile, InputStream is4) throws IOException {
        IResTableParserProvider provider;
        if (resFile.getType() != ResourceType.ARSC) {
            throw new IllegalArgumentException("Unexpected resource type for decode: " + String.valueOf((Object)resFile.getType()) + ", expect '.pb'/'.arsc'");
        }
        IResTableParser parser = null;
        Iterator<IResTableParserProvider> iterator2 = this.resTableParserProviders.iterator();
        while (iterator2.hasNext() && (parser = (provider = iterator2.next()).getParser(resFile)) == null) {
        }
        if (parser == null) {
            throw new JadxRuntimeException("Unknown type of resource file: " + resFile.getOriginalName());
        }
        parser.setBaseFileName(resFile.getDeobfName());
        parser.decode(is4);
        return parser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ResContainer decodeImage(ResourceFile rf5, InputStream inputStream) {
        String name = rf5.getDeobfName();
        if (!name.endsWith(".9.png")) return ResContainer.resourceFileLink(rf5);
        try (ByteArrayOutputStream os4 = new ByteArrayOutputStream();){
            Res9patchStreamDecoder decoder = new Res9patchStreamDecoder();
            if (!decoder.decode(inputStream, os4)) return ResContainer.resourceFileLink(rf5);
            ResContainer resContainer = ResContainer.decodedData(rf5.getDeobfName(), os4.toByteArray());
            return resContainer;
        }
        catch (Exception e15) {
            LOG.error("Failed to decode 9-patch png image, path: {}", (Object)name, (Object)e15);
        }
        return ResContainer.resourceFileLink(rf5);
    }

    private void loadFile(List<ResourceFile> list2, File file2) {
        if (file2 == null || file2.isDirectory()) {
            return;
        }
        for (CustomResourcesLoader loader : this.decompiler.getCustomResourcesLoaders()) {
            if (!loader.load(this, list2, file2)) continue;
            LOG.debug("Custom loader used for {}", (Object)file2.getAbsolutePath());
            return;
        }
        this.defaultLoadFile(list2, file2, "");
    }

    public void defaultLoadFile(List<ResourceFile> list2, File file2, String subDir) {
        if (FileUtils.isZipFile(file2)) {
            try {
                ZipContent zipContent = this.decompiler.getZipReader().open(file2);
                this.decompiler.addCloseable(zipContent);
                for (IZipEntry entry : zipContent.getEntries()) {
                    this.addEntry(list2, file2, entry, subDir);
                }
            }
            catch (Exception e15) {
                throw new RuntimeException("Failed to open zip file: " + file2.getAbsolutePath(), e15);
            }
        } else {
            ResourceType type = ResourceType.getFileType(file2.getAbsolutePath());
            list2.add(ResourceFile.createResourceFile(this.decompiler, file2, type));
        }
    }

    public void addEntry(List<ResourceFile> list2, File zipFile, IZipEntry entry, String subDir) {
        if (entry.isDirectory()) {
            return;
        }
        String name = entry.getName();
        ResourceType type = ResourceType.getFileType(name);
        ResourceFile rf5 = ResourceFile.createResourceFile(this.decompiler, subDir + name, type);
        if (rf5 != null) {
            rf5.setZipEntry(entry);
            list2.add(rf5);
        }
    }

    public static ICodeInfo loadToCodeWriter(InputStream is4) throws IOException {
        return ResourcesLoader.loadToCodeWriter(is4, StandardCharsets.UTF_8);
    }

    public static ICodeInfo loadToCodeWriter(InputStream is4, Charset charset) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        FileUtils.copyStream(is4, baos);
        return new SimpleCodeInfo(baos.toString(charset));
    }

    private synchronized BinaryXMLParser loadBinaryXmlParser() {
        if (this.binaryXmlParser == null) {
            this.binaryXmlParser = new BinaryXMLParser(this.decompiler.getRoot());
        }
        return this.binaryXmlParser;
    }

    public static interface ResourceDecoder<T> {
        public T decode(long var1, InputStream var3) throws IOException;
    }
}

