/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.subscribers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AppendOnlyLinkedArrayList;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class SerializedSubscriber<T>
implements FlowableSubscriber<T>,
Subscription {
    final Subscriber<? super T> downstream;
    final boolean delayError;
    static final int QUEUE_LINK_SIZE = 4;
    Subscription upstream;
    boolean emitting;
    AppendOnlyLinkedArrayList<Object> queue;
    volatile boolean done;

    public SerializedSubscriber(Subscriber<? super T> downstream) {
        this(downstream, false);
    }

    public SerializedSubscriber(@NonNull Subscriber<? super T> actual, boolean delayError) {
        this.downstream = actual;
        this.delayError = delayError;
    }

    @Override
    public void onSubscribe(@NonNull Subscription s15) {
        if (SubscriptionHelper.validate(this.upstream, s15)) {
            this.upstream = s15;
            this.downstream.onSubscribe(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(@NonNull T t15) {
        if (this.done) {
            return;
        }
        if (t15 == null) {
            this.upstream.cancel();
            this.onError(ExceptionHelper.createNullPointerException("onNext called with a null value."));
            return;
        }
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q15 = this.queue;
                if (q15 == null) {
                    this.queue = q15 = new AppendOnlyLinkedArrayList(4);
                }
                q15.add(NotificationLite.next(t15));
                return;
            }
            this.emitting = true;
        }
        this.downstream.onNext(t15);
        this.emitLoop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t15) {
        boolean reportError;
        if (this.done) {
            RxJavaPlugins.onError(t15);
            return;
        }
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.done) {
                reportError = true;
            } else {
                if (this.emitting) {
                    this.done = true;
                    AppendOnlyLinkedArrayList<Object> q15 = this.queue;
                    if (q15 == null) {
                        q15 = new AppendOnlyLinkedArrayList(4);
                        this.queue = q15;
                    }
                    Object err = NotificationLite.error(t15);
                    if (this.delayError) {
                        q15.add(err);
                    } else {
                        q15.setFirst(err);
                    }
                    return;
                }
                this.done = true;
                this.emitting = true;
                reportError = false;
            }
        }
        if (reportError) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.downstream.onError(t15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        SerializedSubscriber serializedSubscriber = this;
        synchronized (serializedSubscriber) {
            if (this.done) {
                return;
            }
            if (this.emitting) {
                AppendOnlyLinkedArrayList<Object> q15 = this.queue;
                if (q15 == null) {
                    this.queue = q15 = new AppendOnlyLinkedArrayList(4);
                }
                q15.add(NotificationLite.complete());
                return;
            }
            this.done = true;
            this.emitting = true;
        }
        this.downstream.onComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emitLoop() {
        AppendOnlyLinkedArrayList<Object> q15;
        do {
            SerializedSubscriber serializedSubscriber = this;
            synchronized (serializedSubscriber) {
                q15 = this.queue;
                if (q15 == null) {
                    this.emitting = false;
                    return;
                }
                this.queue = null;
            }
        } while (!q15.accept(this.downstream));
    }

    @Override
    public void request(long n15) {
        this.upstream.request(n15);
    }

    @Override
    public void cancel() {
        this.upstream.cancel();
    }
}

