/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.processors;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ReplayProcessor<@NonNull T>
extends FlowableProcessor<T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    final ReplayBuffer<T> buffer;
    boolean done;
    final AtomicReference<ReplaySubscription<T>[]> subscribers;
    static final ReplaySubscription[] EMPTY = new ReplaySubscription[0];
    static final ReplaySubscription[] TERMINATED = new ReplaySubscription[0];

    @CheckReturnValue
    @NonNull
    public static <T> ReplayProcessor<T> create() {
        return new ReplayProcessor(new UnboundedReplayBuffer(16));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplayProcessor<T> create(int capacityHint) {
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        return new ReplayProcessor(new UnboundedReplayBuffer(capacityHint));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplayProcessor<T> createWithSize(int maxSize) {
        ObjectHelper.verifyPositive(maxSize, "maxSize");
        return new ReplayProcessor(new SizeBoundReplayBuffer(maxSize));
    }

    @CheckReturnValue
    static <T> ReplayProcessor<T> createUnbounded() {
        return new ReplayProcessor(new SizeBoundReplayBuffer(Integer.MAX_VALUE));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplayProcessor<T> createWithTime(long maxAge, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        ObjectHelper.verifyPositive(maxAge, "maxAge");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return new ReplayProcessor(new SizeAndTimeBoundReplayBuffer(Integer.MAX_VALUE, maxAge, unit, scheduler));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplayProcessor<T> createWithTimeAndSize(long maxAge, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, int maxSize) {
        ObjectHelper.verifyPositive(maxSize, "maxSize");
        ObjectHelper.verifyPositive(maxAge, "maxAge");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return new ReplayProcessor(new SizeAndTimeBoundReplayBuffer(maxSize, maxAge, unit, scheduler));
    }

    ReplayProcessor(ReplayBuffer<T> buffer) {
        this.buffer = buffer;
        this.subscribers = new AtomicReference<ReplaySubscription[]>(EMPTY);
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        ReplaySubscription<? super T> rs4 = new ReplaySubscription<T>(s15, this);
        s15.onSubscribe(rs4);
        if (this.add(rs4) && rs4.cancelled) {
            this.remove(rs4);
            return;
        }
        this.buffer.replay(rs4);
    }

    @Override
    public void onSubscribe(Subscription s15) {
        if (this.done) {
            s15.cancel();
            return;
        }
        s15.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(T t15) {
        ExceptionHelper.nullCheck(t15, "onNext called with a null value.");
        if (this.done) {
            return;
        }
        ReplayBuffer<T> b15 = this.buffer;
        b15.next(t15);
        for (ReplaySubscription<T> rs4 : this.subscribers.get()) {
            b15.replay(rs4);
        }
    }

    @Override
    public void onError(Throwable t15) {
        ExceptionHelper.nullCheck(t15, "onError called with a null Throwable.");
        if (this.done) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.done = true;
        ReplayBuffer<T> b15 = this.buffer;
        b15.error(t15);
        for (ReplaySubscription rs4 : this.subscribers.getAndSet(TERMINATED)) {
            b15.replay(rs4);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        ReplayBuffer<T> b15 = this.buffer;
        b15.complete();
        for (ReplaySubscription rs4 : this.subscribers.getAndSet(TERMINATED)) {
            b15.replay(rs4);
        }
    }

    @Override
    @CheckReturnValue
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    @CheckReturnValue
    int subscriberCount() {
        return this.subscribers.get().length;
    }

    @Override
    @CheckReturnValue
    @Nullable
    public Throwable getThrowable() {
        ReplayBuffer<T> b15 = this.buffer;
        if (b15.isDone()) {
            return b15.getError();
        }
        return null;
    }

    public void cleanupBuffer() {
        this.buffer.trimHead();
    }

    @CheckReturnValue
    public T getValue() {
        return this.buffer.getValue();
    }

    @CheckReturnValue
    public Object[] getValues() {
        Object[] a15 = EMPTY_ARRAY;
        Object[] b15 = this.getValues(a15);
        if (b15 == EMPTY_ARRAY) {
            return new Object[0];
        }
        return b15;
    }

    @CheckReturnValue
    public T[] getValues(T[] array) {
        return this.buffer.getValues(array);
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        ReplayBuffer<T> b15 = this.buffer;
        return b15.isDone() && b15.getError() == null;
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        ReplayBuffer<T> b15 = this.buffer;
        return b15.isDone() && b15.getError() != null;
    }

    @CheckReturnValue
    public boolean hasValue() {
        return this.buffer.size() != 0;
    }

    @CheckReturnValue
    int size() {
        return this.buffer.size();
    }

    boolean add(ReplaySubscription<T> rs4) {
        ReplaySubscription[] b15;
        ReplaySubscription<T>[] a15;
        do {
            if ((a15 = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int len = a15.length;
            b15 = new ReplaySubscription[len + 1];
            System.arraycopy(a15, 0, b15, 0, len);
            b15[len] = rs4;
        } while (!this.subscribers.compareAndSet(a15, b15));
        return true;
    }

    void remove(ReplaySubscription<T> rs4) {
        ReplaySubscription[] b15;
        ReplaySubscription<T>[] a15;
        do {
            if ((a15 = this.subscribers.get()) == TERMINATED || a15 == EMPTY) {
                return;
            }
            int len = a15.length;
            int j15 = -1;
            for (int i15 = 0; i15 < len; ++i15) {
                if (a15[i15] != rs4) continue;
                j15 = i15;
                break;
            }
            if (j15 < 0) {
                return;
            }
            if (len == 1) {
                b15 = EMPTY;
                continue;
            }
            b15 = new ReplaySubscription[len - 1];
            System.arraycopy(a15, 0, b15, 0, j15);
            System.arraycopy(a15, j15 + 1, b15, j15, len - j15 - 1);
        } while (!this.subscribers.compareAndSet(a15, b15));
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    implements ReplayBuffer<T> {
        final int maxSize;
        final long maxAge;
        final TimeUnit unit;
        final Scheduler scheduler;
        int size;
        volatile TimedNode<T> head;
        TimedNode<T> tail;
        Throwable error;
        volatile boolean done;

        SizeAndTimeBoundReplayBuffer(int maxSize, long maxAge, TimeUnit unit, Scheduler scheduler) {
            this.maxSize = maxSize;
            this.maxAge = maxAge;
            this.unit = unit;
            this.scheduler = scheduler;
            TimedNode<Object> h15 = new TimedNode<Object>(null, 0L);
            this.tail = h15;
            this.head = h15;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                TimedNode<T> h15 = this.head;
                this.head = (TimedNode)h15.get();
            }
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode h16 = this.head;
            while (true) {
                if (this.size <= 1) {
                    this.head = h16;
                    break;
                }
                TimedNode next = (TimedNode)h16.get();
                if (next.time > limit) {
                    this.head = h16;
                    break;
                }
                h16 = next;
                --this.size;
            }
        }

        void trimFinal() {
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode h15 = this.head;
            while (true) {
                TimedNode next;
                if ((next = (TimedNode)h15.get()) == null) {
                    if (h15.value != null) {
                        this.head = new TimedNode<Object>(null, 0L);
                        break;
                    }
                    this.head = h15;
                    break;
                }
                if (next.time > limit) {
                    if (h15.value != null) {
                        TimedNode<Object> n15 = new TimedNode<Object>(null, 0L);
                        n15.lazySet(h15.get());
                        this.head = n15;
                        break;
                    }
                    this.head = h15;
                    break;
                }
                h15 = next;
            }
        }

        @Override
        public void trimHead() {
            if (this.head.value != null) {
                TimedNode<Object> n15 = new TimedNode<Object>(null, 0L);
                n15.lazySet(this.head.get());
                this.head = n15;
            }
        }

        @Override
        public void next(T value) {
            TimedNode<T> n15 = new TimedNode<T>(value, this.scheduler.now(this.unit));
            TimedNode<T> t15 = this.tail;
            this.tail = n15;
            ++this.size;
            t15.set(n15);
            this.trim();
        }

        @Override
        public void error(Throwable ex4) {
            this.trimFinal();
            this.error = ex4;
            this.done = true;
        }

        @Override
        public void complete() {
            this.trimFinal();
            this.done = true;
        }

        @Override
        @Nullable
        public T getValue() {
            TimedNode next;
            TimedNode h15 = this.head;
            while ((next = (TimedNode)h15.get()) != null) {
                h15 = next;
            }
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            if (h15.time < limit) {
                return null;
            }
            return h15.value;
        }

        @Override
        public T[] getValues(T[] array) {
            TimedNode h15 = this.getHead();
            int s15 = this.size(h15);
            if (s15 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                if (array.length < s15) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), s15);
                }
                for (int i15 = 0; i15 != s15; ++i15) {
                    TimedNode next = (TimedNode)h15.get();
                    array[i15] = next.value;
                    h15 = next;
                }
                if (array.length > s15) {
                    array[s15] = null;
                }
            }
            return array;
        }

        TimedNode<T> getHead() {
            long ts4;
            TimedNode index = this.head;
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode next = (TimedNode)index.get();
            while (next != null && (ts4 = next.time) <= limit) {
                index = next;
                next = (TimedNode)index.get();
            }
            return index;
        }

        @Override
        public void replay(ReplaySubscription<T> rs4) {
            if (rs4.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a15 = rs4.downstream;
            TimedNode index = (TimedNode)rs4.index;
            if (index == null) {
                index = this.getHead();
            }
            long e15 = rs4.emitted;
            do {
                boolean d15;
                long r15 = rs4.requested.get();
                while (e15 != r15) {
                    boolean empty;
                    if (rs4.cancelled) {
                        rs4.index = null;
                        return;
                    }
                    d15 = this.done;
                    TimedNode next = (TimedNode)index.get();
                    boolean bl4 = empty = next == null;
                    if (d15 && empty) {
                        rs4.index = null;
                        rs4.cancelled = true;
                        Throwable ex4 = this.error;
                        if (ex4 == null) {
                            a15.onComplete();
                        } else {
                            a15.onError(ex4);
                        }
                        return;
                    }
                    if (empty) break;
                    a15.onNext(next.value);
                    ++e15;
                    index = next;
                }
                if (e15 == r15) {
                    if (rs4.cancelled) {
                        rs4.index = null;
                        return;
                    }
                    d15 = this.done;
                    if (d15 && index.get() == null) {
                        rs4.index = null;
                        rs4.cancelled = true;
                        Throwable ex5 = this.error;
                        if (ex5 == null) {
                            a15.onComplete();
                        } else {
                            a15.onError(ex5);
                        }
                        return;
                    }
                }
                rs4.index = index;
                rs4.emitted = e15;
            } while ((missed = rs4.addAndGet(-missed)) != 0);
        }

        @Override
        public int size() {
            return this.size(this.getHead());
        }

        int size(TimedNode<T> h15) {
            TimedNode next;
            int s15;
            for (s15 = 0; s15 != Integer.MAX_VALUE && (next = (TimedNode)h15.get()) != null; ++s15) {
                h15 = next;
            }
            return s15;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }
    }

    static final class SizeBoundReplayBuffer<@NonNull T>
    implements ReplayBuffer<T> {
        final int maxSize;
        int size;
        volatile Node<T> head;
        Node<T> tail;
        Throwable error;
        volatile boolean done;

        SizeBoundReplayBuffer(int maxSize) {
            this.maxSize = maxSize;
            Node<Object> h15 = new Node<Object>(null);
            this.tail = h15;
            this.head = h15;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                Node<T> h15 = this.head;
                this.head = (Node)h15.get();
            }
        }

        @Override
        public void next(T value) {
            Node<T> n15 = new Node<T>(value);
            Node<T> t15 = this.tail;
            this.tail = n15;
            ++this.size;
            t15.set(n15);
            this.trim();
        }

        @Override
        public void error(Throwable ex4) {
            this.error = ex4;
            this.trimHead();
            this.done = true;
        }

        @Override
        public void complete() {
            this.trimHead();
            this.done = true;
        }

        @Override
        public void trimHead() {
            if (this.head.value != null) {
                Node<Object> n15 = new Node<Object>(null);
                n15.lazySet(this.head.get());
                this.head = n15;
            }
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public T getValue() {
            Node h15 = this.head;
            Node n15;
            while ((n15 = (Node)h15.get()) != null) {
                h15 = n15;
            }
            return h15.value;
        }

        @Override
        public T[] getValues(T[] array) {
            Node next;
            Node h15;
            int s15 = 0;
            Node h05 = h15 = this.head;
            while ((next = (Node)h05.get()) != null) {
                ++s15;
                h05 = next;
            }
            if (array.length < s15) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s15);
            }
            for (int j15 = 0; j15 < s15; ++j15) {
                h15 = (Node)h15.get();
                array[j15] = h15.value;
            }
            if (array.length > s15) {
                array[s15] = null;
            }
            return array;
        }

        @Override
        public void replay(ReplaySubscription<T> rs4) {
            if (rs4.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a15 = rs4.downstream;
            Node index = (Node)rs4.index;
            if (index == null) {
                index = this.head;
            }
            long e15 = rs4.emitted;
            do {
                boolean d15;
                long r15 = rs4.requested.get();
                while (e15 != r15) {
                    boolean empty;
                    if (rs4.cancelled) {
                        rs4.index = null;
                        return;
                    }
                    d15 = this.done;
                    Node next = (Node)index.get();
                    boolean bl4 = empty = next == null;
                    if (d15 && empty) {
                        rs4.index = null;
                        rs4.cancelled = true;
                        Throwable ex4 = this.error;
                        if (ex4 == null) {
                            a15.onComplete();
                        } else {
                            a15.onError(ex4);
                        }
                        return;
                    }
                    if (empty) break;
                    a15.onNext(next.value);
                    ++e15;
                    index = next;
                }
                if (e15 == r15) {
                    if (rs4.cancelled) {
                        rs4.index = null;
                        return;
                    }
                    d15 = this.done;
                    if (d15 && index.get() == null) {
                        rs4.index = null;
                        rs4.cancelled = true;
                        Throwable ex5 = this.error;
                        if (ex5 == null) {
                            a15.onComplete();
                        } else {
                            a15.onError(ex5);
                        }
                        return;
                    }
                }
                rs4.index = index;
                rs4.emitted = e15;
            } while ((missed = rs4.addAndGet(-missed)) != 0);
        }

        @Override
        public int size() {
            Node next;
            int s15;
            Node h15 = this.head;
            for (s15 = 0; s15 != Integer.MAX_VALUE && (next = (Node)h15.get()) != null; ++s15) {
                h15 = next;
            }
            return s15;
        }
    }

    static final class TimedNode<T>
    extends AtomicReference<TimedNode<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;
        final long time;

        TimedNode(T value, long time) {
            this.value = value;
            this.time = time;
        }
    }

    static final class Node<T>
    extends AtomicReference<Node<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;

        Node(T value) {
            this.value = value;
        }
    }

    static final class UnboundedReplayBuffer<T>
    implements ReplayBuffer<T> {
        final List<T> buffer;
        Throwable error;
        volatile boolean done;
        volatile int size;

        UnboundedReplayBuffer(int capacityHint) {
            this.buffer = new ArrayList<T>(capacityHint);
        }

        @Override
        public void next(T value) {
            this.buffer.add(value);
            ++this.size;
        }

        @Override
        public void error(Throwable ex4) {
            this.error = ex4;
            this.done = true;
        }

        @Override
        public void complete() {
            this.done = true;
        }

        @Override
        public void trimHead() {
        }

        @Override
        @Nullable
        public T getValue() {
            int s15 = this.size;
            if (s15 == 0) {
                return null;
            }
            return this.buffer.get(s15 - 1);
        }

        @Override
        public T[] getValues(T[] array) {
            int s15 = this.size;
            if (s15 == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
                return array;
            }
            List<T> b15 = this.buffer;
            if (array.length < s15) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s15);
            }
            for (int i15 = 0; i15 < s15; ++i15) {
                array[i15] = b15.get(i15);
            }
            if (array.length > s15) {
                array[s15] = null;
            }
            return array;
        }

        @Override
        public void replay(ReplaySubscription<T> rs4) {
            int index;
            if (rs4.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            List<T> b15 = this.buffer;
            Subscriber<T> a15 = rs4.downstream;
            Integer indexObject = (Integer)rs4.index;
            if (indexObject != null) {
                index = indexObject;
            } else {
                index = 0;
                rs4.index = 0;
            }
            long e15 = rs4.emitted;
            do {
                int s15;
                boolean d15;
                long r15 = rs4.requested.get();
                while (e15 != r15) {
                    if (rs4.cancelled) {
                        rs4.index = null;
                        return;
                    }
                    d15 = this.done;
                    s15 = this.size;
                    if (d15 && index == s15) {
                        rs4.index = null;
                        rs4.cancelled = true;
                        Throwable ex4 = this.error;
                        if (ex4 == null) {
                            a15.onComplete();
                        } else {
                            a15.onError(ex4);
                        }
                        return;
                    }
                    if (index == s15) break;
                    a15.onNext(b15.get(index));
                    ++index;
                    ++e15;
                }
                if (e15 == r15) {
                    if (rs4.cancelled) {
                        rs4.index = null;
                        return;
                    }
                    d15 = this.done;
                    s15 = this.size;
                    if (d15 && index == s15) {
                        rs4.index = null;
                        rs4.cancelled = true;
                        Throwable ex5 = this.error;
                        if (ex5 == null) {
                            a15.onComplete();
                        } else {
                            a15.onError(ex5);
                        }
                        return;
                    }
                }
                rs4.index = index;
                rs4.emitted = e15;
            } while ((missed = rs4.addAndGet(-missed)) != 0);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }
    }

    static final class ReplaySubscription<@NonNull T>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = 466549804534799122L;
        final Subscriber<? super T> downstream;
        final ReplayProcessor<T> state;
        Object index;
        final AtomicLong requested;
        volatile boolean cancelled;
        long emitted;

        ReplaySubscription(Subscriber<? super T> actual, ReplayProcessor<T> state) {
            this.downstream = actual;
            this.state = state;
            this.requested = new AtomicLong();
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.state.buffer.replay(this);
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }
    }

    static interface ReplayBuffer<@NonNull T> {
        public void next(T var1);

        public void error(Throwable var1);

        public void complete();

        public void replay(ReplaySubscription<T> var1);

        public int size();

        @Nullable
        public T getValue();

        public T[] getValues(T[] var1);

        public boolean isDone();

        public Throwable getError();

        public void trimHead();
    }
}

