/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.processors;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AppendOnlyLinkedArrayList;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class BehaviorProcessor<@NonNull T>
extends FlowableProcessor<T> {
    final AtomicReference<BehaviorSubscription<T>[]> subscribers;
    static final Object[] EMPTY_ARRAY = new Object[0];
    static final BehaviorSubscription[] EMPTY = new BehaviorSubscription[0];
    static final BehaviorSubscription[] TERMINATED = new BehaviorSubscription[0];
    final ReadWriteLock lock;
    final Lock readLock;
    final Lock writeLock;
    final AtomicReference<Object> value = new AtomicReference();
    final AtomicReference<Throwable> terminalEvent;
    long index;

    @CheckReturnValue
    @NonNull
    public static <T> BehaviorProcessor<T> create() {
        return new BehaviorProcessor<T>();
    }

    @CheckReturnValue
    @NonNull
    public static <T> BehaviorProcessor<T> createDefault(T defaultValue) {
        Objects.requireNonNull(defaultValue, "defaultValue is null");
        return new BehaviorProcessor<T>(defaultValue);
    }

    BehaviorProcessor() {
        this.lock = new ReentrantReadWriteLock();
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
        this.subscribers = new AtomicReference<BehaviorSubscription[]>(EMPTY);
        this.terminalEvent = new AtomicReference();
    }

    BehaviorProcessor(T defaultValue) {
        this();
        this.value.lazySet(defaultValue);
    }

    @Override
    protected void subscribeActual(@NonNull Subscriber<? super T> s15) {
        BehaviorSubscription<T> bs4 = new BehaviorSubscription<T>(s15, this);
        s15.onSubscribe(bs4);
        if (this.add(bs4)) {
            if (bs4.cancelled) {
                this.remove(bs4);
            } else {
                bs4.emitFirst();
            }
        } else {
            Throwable ex4 = this.terminalEvent.get();
            if (ex4 == ExceptionHelper.TERMINATED) {
                s15.onComplete();
            } else {
                s15.onError(ex4);
            }
        }
    }

    @Override
    public void onSubscribe(@NonNull Subscription s15) {
        if (this.terminalEvent.get() != null) {
            s15.cancel();
            return;
        }
        s15.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(@NonNull T t15) {
        ExceptionHelper.nullCheck(t15, "onNext called with a null value.");
        if (this.terminalEvent.get() != null) {
            return;
        }
        Object o15 = NotificationLite.next(t15);
        this.setCurrent(o15);
        for (BehaviorSubscription<T> bs4 : this.subscribers.get()) {
            bs4.emitNext(o15, this.index);
        }
    }

    @Override
    public void onError(@NonNull Throwable t15) {
        ExceptionHelper.nullCheck(t15, "onError called with a null Throwable.");
        if (!this.terminalEvent.compareAndSet(null, t15)) {
            RxJavaPlugins.onError(t15);
            return;
        }
        Object o15 = NotificationLite.error(t15);
        for (BehaviorSubscription<T> bs4 : this.terminate(o15)) {
            bs4.emitNext(o15, this.index);
        }
    }

    @Override
    public void onComplete() {
        if (!this.terminalEvent.compareAndSet(null, ExceptionHelper.TERMINATED)) {
            return;
        }
        Object o15 = NotificationLite.complete();
        for (BehaviorSubscription<T> bs4 : this.terminate(o15)) {
            bs4.emitNext(o15, this.index);
        }
    }

    @CheckReturnValue
    public boolean offer(@NonNull T t15) {
        BehaviorSubscription<T>[] array;
        ExceptionHelper.nullCheck(t15, "offer called with a null value.");
        for (BehaviorSubscription<T> s15 : array = this.subscribers.get()) {
            if (!s15.isFull()) continue;
            return false;
        }
        Object o15 = NotificationLite.next(t15);
        this.setCurrent(o15);
        for (BehaviorSubscription<T> bs4 : array) {
            bs4.emitNext(o15, this.index);
        }
        return true;
    }

    @Override
    @CheckReturnValue
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    @CheckReturnValue
    int subscriberCount() {
        return this.subscribers.get().length;
    }

    @Override
    @CheckReturnValue
    @Nullable
    public Throwable getThrowable() {
        Object o15 = this.value.get();
        if (NotificationLite.isError(o15)) {
            return NotificationLite.getError(o15);
        }
        return null;
    }

    @CheckReturnValue
    @Nullable
    public T getValue() {
        Object o15 = this.value.get();
        if (NotificationLite.isComplete(o15) || NotificationLite.isError(o15)) {
            return null;
        }
        return NotificationLite.getValue(o15);
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        Object o15 = this.value.get();
        return NotificationLite.isComplete(o15);
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        Object o15 = this.value.get();
        return NotificationLite.isError(o15);
    }

    @CheckReturnValue
    public boolean hasValue() {
        Object o15 = this.value.get();
        return o15 != null && !NotificationLite.isComplete(o15) && !NotificationLite.isError(o15);
    }

    boolean add(BehaviorSubscription<T> rs4) {
        BehaviorSubscription[] b15;
        BehaviorSubscription<T>[] a15;
        do {
            if ((a15 = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int len = a15.length;
            b15 = new BehaviorSubscription[len + 1];
            System.arraycopy(a15, 0, b15, 0, len);
            b15[len] = rs4;
        } while (!this.subscribers.compareAndSet(a15, b15));
        return true;
    }

    void remove(BehaviorSubscription<T> rs4) {
        BehaviorSubscription[] b15;
        BehaviorSubscription<T>[] a15;
        do {
            int len;
            if ((len = (a15 = this.subscribers.get()).length) == 0) {
                return;
            }
            int j15 = -1;
            for (int i15 = 0; i15 < len; ++i15) {
                if (a15[i15] != rs4) continue;
                j15 = i15;
                break;
            }
            if (j15 < 0) {
                return;
            }
            if (len == 1) {
                b15 = EMPTY;
                continue;
            }
            b15 = new BehaviorSubscription[len - 1];
            System.arraycopy(a15, 0, b15, 0, j15);
            System.arraycopy(a15, j15 + 1, b15, j15, len - j15 - 1);
        } while (!this.subscribers.compareAndSet(a15, b15));
    }

    BehaviorSubscription<T>[] terminate(Object terminalValue) {
        this.setCurrent(terminalValue);
        return this.subscribers.getAndSet(TERMINATED);
    }

    void setCurrent(Object o15) {
        Lock wl4 = this.writeLock;
        wl4.lock();
        ++this.index;
        this.value.lazySet(o15);
        wl4.unlock();
    }

    static final class BehaviorSubscription<@NonNull T>
    extends AtomicLong
    implements Subscription,
    AppendOnlyLinkedArrayList.NonThrowingPredicate<Object> {
        private static final long serialVersionUID = 3293175281126227086L;
        final Subscriber<? super T> downstream;
        final BehaviorProcessor<T> state;
        boolean next;
        boolean emitting;
        AppendOnlyLinkedArrayList<Object> queue;
        boolean fastPath;
        volatile boolean cancelled;
        long index;

        BehaviorSubscription(Subscriber<? super T> actual, BehaviorProcessor<T> state) {
            this.downstream = actual;
            this.state = state;
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this, n15);
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitFirst() {
            Object o15;
            if (this.cancelled) {
                return;
            }
            BehaviorSubscription behaviorSubscription = this;
            synchronized (behaviorSubscription) {
                if (this.cancelled) {
                    return;
                }
                if (this.next) {
                    return;
                }
                BehaviorProcessor<T> s15 = this.state;
                Lock readLock = s15.readLock;
                readLock.lock();
                this.index = s15.index;
                o15 = s15.value.get();
                readLock.unlock();
                this.emitting = o15 != null;
                this.next = true;
            }
            if (o15 != null) {
                if (this.test(o15)) {
                    return;
                }
                this.emitLoop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitNext(Object value, long stateIndex) {
            if (this.cancelled) {
                return;
            }
            if (!this.fastPath) {
                BehaviorSubscription behaviorSubscription = this;
                synchronized (behaviorSubscription) {
                    if (this.cancelled) {
                        return;
                    }
                    if (this.index == stateIndex) {
                        return;
                    }
                    if (this.emitting) {
                        AppendOnlyLinkedArrayList<Object> q15 = this.queue;
                        if (q15 == null) {
                            this.queue = q15 = new AppendOnlyLinkedArrayList(4);
                        }
                        q15.add(value);
                        return;
                    }
                    this.next = true;
                }
                this.fastPath = true;
            }
            this.test(value);
        }

        @Override
        public boolean test(Object o15) {
            if (this.cancelled) {
                return true;
            }
            if (NotificationLite.isComplete(o15)) {
                this.downstream.onComplete();
                return true;
            }
            if (NotificationLite.isError(o15)) {
                this.downstream.onError(NotificationLite.getError(o15));
                return true;
            }
            long r15 = this.get();
            if (r15 != 0L) {
                this.downstream.onNext(NotificationLite.getValue(o15));
                if (r15 != Long.MAX_VALUE) {
                    this.decrementAndGet();
                }
                return false;
            }
            this.cancel();
            this.downstream.onError(MissingBackpressureException.createDefault());
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitLoop() {
            while (!this.cancelled) {
                AppendOnlyLinkedArrayList<Object> q15;
                BehaviorSubscription behaviorSubscription = this;
                synchronized (behaviorSubscription) {
                    q15 = this.queue;
                    if (q15 == null) {
                        this.emitting = false;
                        return;
                    }
                    this.queue = null;
                }
                q15.forEachWhile(this);
            }
            return;
        }

        public boolean isFull() {
            return this.get() == 0L;
        }
    }
}

