/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.processors;

import io.reactivex.rxjava3.annotations.CheckReturnValue;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class AsyncProcessor<@NonNull T>
extends FlowableProcessor<T> {
    static final AsyncSubscription[] EMPTY = new AsyncSubscription[0];
    static final AsyncSubscription[] TERMINATED = new AsyncSubscription[0];
    final AtomicReference<AsyncSubscription<T>[]> subscribers = new AtomicReference<AsyncSubscription[]>(EMPTY);
    Throwable error;
    T value;

    @CheckReturnValue
    @NonNull
    public static <T> AsyncProcessor<T> create() {
        return new AsyncProcessor<T>();
    }

    AsyncProcessor() {
    }

    @Override
    public void onSubscribe(@NonNull Subscription s15) {
        if (this.subscribers.get() == TERMINATED) {
            s15.cancel();
            return;
        }
        s15.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(@NonNull T t15) {
        ExceptionHelper.nullCheck(t15, "onNext called with a null value.");
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        this.value = t15;
    }

    @Override
    public void onError(@NonNull Throwable t15) {
        ExceptionHelper.nullCheck(t15, "onError called with a null Throwable.");
        if (this.subscribers.get() == TERMINATED) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.value = null;
        this.error = t15;
        for (AsyncSubscription as4 : this.subscribers.getAndSet(TERMINATED)) {
            as4.onError(t15);
        }
    }

    @Override
    public void onComplete() {
        if (this.subscribers.get() == TERMINATED) {
            return;
        }
        T v15 = this.value;
        AsyncSubscription[] array = this.subscribers.getAndSet(TERMINATED);
        if (v15 == null) {
            for (AsyncSubscription as4 : array) {
                as4.onComplete();
            }
        } else {
            for (AsyncSubscription as5 : array) {
                as5.complete(v15);
            }
        }
    }

    @Override
    @CheckReturnValue
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        return this.subscribers.get() == TERMINATED && this.error != null;
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        return this.subscribers.get() == TERMINATED && this.error == null;
    }

    @Override
    @CheckReturnValue
    @Nullable
    public Throwable getThrowable() {
        return this.subscribers.get() == TERMINATED ? this.error : null;
    }

    @Override
    protected void subscribeActual(@NonNull Subscriber<? super T> s15) {
        AsyncSubscription<T> as4 = new AsyncSubscription<T>(s15, this);
        s15.onSubscribe(as4);
        if (this.add(as4)) {
            if (as4.isCancelled()) {
                this.remove(as4);
            }
        } else {
            Throwable ex4 = this.error;
            if (ex4 != null) {
                s15.onError(ex4);
            } else {
                T v15 = this.value;
                if (v15 != null) {
                    as4.complete(v15);
                } else {
                    as4.onComplete();
                }
            }
        }
    }

    boolean add(AsyncSubscription<T> ps4) {
        AsyncSubscription[] b15;
        AsyncSubscription<T>[] a15;
        do {
            if ((a15 = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int n15 = a15.length;
            b15 = new AsyncSubscription[n15 + 1];
            System.arraycopy(a15, 0, b15, 0, n15);
            b15[n15] = ps4;
        } while (!this.subscribers.compareAndSet(a15, b15));
        return true;
    }

    void remove(AsyncSubscription<T> ps4) {
        AsyncSubscription[] b15;
        AsyncSubscription<T>[] a15;
        do {
            int n15;
            if ((n15 = (a15 = this.subscribers.get()).length) == 0) {
                return;
            }
            int j15 = -1;
            for (int i15 = 0; i15 < n15; ++i15) {
                if (a15[i15] != ps4) continue;
                j15 = i15;
                break;
            }
            if (j15 < 0) {
                return;
            }
            if (n15 == 1) {
                b15 = EMPTY;
                continue;
            }
            b15 = new AsyncSubscription[n15 - 1];
            System.arraycopy(a15, 0, b15, 0, j15);
            System.arraycopy(a15, j15 + 1, b15, j15, n15 - j15 - 1);
        } while (!this.subscribers.compareAndSet(a15, b15));
    }

    @CheckReturnValue
    public boolean hasValue() {
        return this.subscribers.get() == TERMINATED && this.value != null;
    }

    @CheckReturnValue
    @Nullable
    public T getValue() {
        return this.subscribers.get() == TERMINATED ? (T)this.value : null;
    }

    static final class AsyncSubscription<@NonNull T>
    extends DeferredScalarSubscription<T> {
        private static final long serialVersionUID = 5629876084736248016L;
        final AsyncProcessor<T> parent;

        AsyncSubscription(Subscriber<? super T> actual, AsyncProcessor<T> parent) {
            super(actual);
            this.parent = parent;
        }

        @Override
        public void cancel() {
            if (super.tryCancel()) {
                this.parent.remove(this);
            }
        }

        void onComplete() {
            if (!this.isCancelled()) {
                this.downstream.onComplete();
            }
        }

        void onError(Throwable t15) {
            if (this.isCancelled()) {
                RxJavaPlugins.onError(t15);
            } else {
                this.downstream.onError(t15);
            }
        }
    }
}

