/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.util;

import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.Emitter;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;

public final class AtomicThrowable
extends AtomicReference<Throwable> {
    private static final long serialVersionUID = 3949248817947090603L;

    public boolean tryAddThrowable(Throwable t15) {
        return ExceptionHelper.addThrowable(this, t15);
    }

    public boolean tryAddThrowableOrReport(Throwable t15) {
        if (this.tryAddThrowable(t15)) {
            return true;
        }
        RxJavaPlugins.onError(t15);
        return false;
    }

    public Throwable terminate() {
        return ExceptionHelper.terminate(this);
    }

    public boolean isTerminated() {
        return this.get() == ExceptionHelper.TERMINATED;
    }

    public void tryTerminateAndReport() {
        Throwable ex4 = this.terminate();
        if (ex4 != null && ex4 != ExceptionHelper.TERMINATED) {
            RxJavaPlugins.onError(ex4);
        }
    }

    public void tryTerminateConsumer(Subscriber<?> consumer) {
        Throwable ex4 = this.terminate();
        if (ex4 == null) {
            consumer.onComplete();
        } else if (ex4 != ExceptionHelper.TERMINATED) {
            consumer.onError(ex4);
        }
    }

    public void tryTerminateConsumer(Observer<?> consumer) {
        Throwable ex4 = this.terminate();
        if (ex4 == null) {
            consumer.onComplete();
        } else if (ex4 != ExceptionHelper.TERMINATED) {
            consumer.onError(ex4);
        }
    }

    public void tryTerminateConsumer(MaybeObserver<?> consumer) {
        Throwable ex4 = this.terminate();
        if (ex4 == null) {
            consumer.onComplete();
        } else if (ex4 != ExceptionHelper.TERMINATED) {
            consumer.onError(ex4);
        }
    }

    public void tryTerminateConsumer(SingleObserver<?> consumer) {
        Throwable ex4 = this.terminate();
        if (ex4 != null && ex4 != ExceptionHelper.TERMINATED) {
            consumer.onError(ex4);
        }
    }

    public void tryTerminateConsumer(CompletableObserver consumer) {
        Throwable ex4 = this.terminate();
        if (ex4 == null) {
            consumer.onComplete();
        } else if (ex4 != ExceptionHelper.TERMINATED) {
            consumer.onError(ex4);
        }
    }

    public void tryTerminateConsumer(Emitter<?> consumer) {
        Throwable ex4 = this.terminate();
        if (ex4 == null) {
            consumer.onComplete();
        } else if (ex4 != ExceptionHelper.TERMINATED) {
            consumer.onError(ex4);
        }
    }
}

