/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.subscribers;

import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

public final class ForEachWhileSubscriber<T>
extends AtomicReference<Subscription>
implements FlowableSubscriber<T>,
Disposable {
    private static final long serialVersionUID = -4403180040475402120L;
    final Predicate<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    boolean done;

    public ForEachWhileSubscriber(Predicate<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
    }

    @Override
    public void onSubscribe(Subscription s15) {
        SubscriptionHelper.setOnce(this, s15, Long.MAX_VALUE);
    }

    @Override
    public void onNext(T t15) {
        boolean b15;
        if (this.done) {
            return;
        }
        try {
            b15 = this.onNext.test(t15);
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            this.dispose();
            this.onError(ex4);
            return;
        }
        if (!b15) {
            this.dispose();
            this.onComplete();
        }
    }

    @Override
    public void onError(Throwable t15) {
        if (this.done) {
            RxJavaPlugins.onError(t15);
            return;
        }
        this.done = true;
        try {
            this.onError.accept(t15);
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            RxJavaPlugins.onError(new CompositeException(t15, ex4));
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        try {
            this.onComplete.run();
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            RxJavaPlugins.onError(ex4);
        }
    }

    @Override
    public void dispose() {
        SubscriptionHelper.cancel(this);
    }

    @Override
    public boolean isDisposed() {
        return this.get() == SubscriptionHelper.CANCELLED;
    }
}

