/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.schedulers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.internal.schedulers.NonBlockingThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class RxThreadFactory
extends AtomicLong
implements ThreadFactory {
    private static final long serialVersionUID = -7789753024099756196L;
    final String prefix;
    final int priority;
    final boolean nonBlocking;

    public RxThreadFactory(String prefix) {
        this(prefix, 5, false);
    }

    public RxThreadFactory(String prefix, int priority) {
        this(prefix, priority, false);
    }

    public RxThreadFactory(String prefix, int priority, boolean nonBlocking) {
        this.prefix = prefix;
        this.priority = priority;
        this.nonBlocking = nonBlocking;
    }

    @Override
    public Thread newThread(@NonNull Runnable r15) {
        StringBuilder nameBuilder = new StringBuilder(this.prefix).append('-').append(this.incrementAndGet());
        String name = nameBuilder.toString();
        Thread t15 = this.nonBlocking ? new RxCustomThread(r15, name) : new Thread(r15, name);
        t15.setPriority(this.priority);
        t15.setDaemon(true);
        return t15;
    }

    @Override
    public String toString() {
        return "RxThreadFactory[" + this.prefix + "]";
    }

    static final class RxCustomThread
    extends Thread
    implements NonBlockingThread {
        RxCustomThread(Runnable run, String name) {
            super(run, name);
        }
    }
}

