/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;

public final class SingleFromSupplier<T>
extends Single<T> {
    final Supplier<? extends T> supplier;

    public SingleFromSupplier(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        T value;
        Disposable d15 = Disposable.empty();
        observer.onSubscribe(d15);
        if (d15.isDisposed()) {
            return;
        }
        try {
            value = Objects.requireNonNull(this.supplier.get(), "The supplier returned a null value");
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            if (!d15.isDisposed()) {
                observer.onError(ex4);
            } else {
                RxJavaPlugins.onError(ex4);
            }
            return;
        }
        if (!d15.isDisposed()) {
            observer.onSuccess(value);
        }
    }
}

