/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;

public final class SingleDoOnTerminate<T>
extends Single<T> {
    final SingleSource<T> source;
    final Action onTerminate;

    public SingleDoOnTerminate(SingleSource<T> source, Action onTerminate) {
        this.source = source;
        this.onTerminate = onTerminate;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        this.source.subscribe(new DoOnTerminate(observer));
    }

    final class DoOnTerminate
    implements SingleObserver<T> {
        final SingleObserver<? super T> downstream;

        DoOnTerminate(SingleObserver<? super T> observer) {
            this.downstream = observer;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.downstream.onSubscribe(d15);
        }

        @Override
        public void onSuccess(T value) {
            try {
                SingleDoOnTerminate.this.onTerminate.run();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.downstream.onError(ex4);
                return;
            }
            this.downstream.onSuccess(value);
        }

        @Override
        public void onError(Throwable e15) {
            try {
                SingleDoOnTerminate.this.onTerminate.run();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                e15 = new CompositeException(e15, ex4);
            }
            this.downstream.onError(e15);
        }
    }
}

