/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class SingleDoOnSubscribe<T>
extends Single<T> {
    final SingleSource<T> source;
    final Consumer<? super Disposable> onSubscribe;

    public SingleDoOnSubscribe(SingleSource<T> source, Consumer<? super Disposable> onSubscribe) {
        this.source = source;
        this.onSubscribe = onSubscribe;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        this.source.subscribe(new DoOnSubscribeSingleObserver<T>(observer, this.onSubscribe));
    }

    static final class DoOnSubscribeSingleObserver<T>
    implements SingleObserver<T> {
        final SingleObserver<? super T> downstream;
        final Consumer<? super Disposable> onSubscribe;
        boolean done;

        DoOnSubscribeSingleObserver(SingleObserver<? super T> actual, Consumer<? super Disposable> onSubscribe) {
            this.downstream = actual;
            this.onSubscribe = onSubscribe;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            try {
                this.onSubscribe.accept(d15);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.done = true;
                d15.dispose();
                EmptyDisposable.error(ex4, this.downstream);
                return;
            }
            this.downstream.onSubscribe(d15);
        }

        @Override
        public void onSuccess(T value) {
            if (this.done) {
                return;
            }
            this.downstream.onSuccess(value);
        }

        @Override
        public void onError(Throwable e15) {
            if (this.done) {
                RxJavaPlugins.onError(e15);
                return;
            }
            this.downstream.onError(e15);
        }
    }
}

