/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiPredicate;

public final class SingleContains<T>
extends Single<Boolean> {
    final SingleSource<T> source;
    final Object value;
    final BiPredicate<Object, Object> comparer;

    public SingleContains(SingleSource<T> source, Object value, BiPredicate<Object, Object> comparer) {
        this.source = source;
        this.value = value;
        this.comparer = comparer;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super Boolean> observer) {
        this.source.subscribe(new ContainsSingleObserver(observer));
    }

    final class ContainsSingleObserver
    implements SingleObserver<T> {
        private final SingleObserver<? super Boolean> downstream;

        ContainsSingleObserver(SingleObserver<? super Boolean> observer) {
            this.downstream = observer;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.downstream.onSubscribe(d15);
        }

        @Override
        public void onSuccess(T v15) {
            boolean b15;
            try {
                b15 = SingleContains.this.comparer.test(v15, SingleContains.this.value);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.downstream.onError(ex4);
                return;
            }
            this.downstream.onSuccess((Boolean)b15);
        }

        @Override
        public void onError(Throwable e15) {
            this.downstream.onError(e15);
        }
    }
}

