/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.single;

import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleCache<T>
extends Single<T>
implements SingleObserver<T> {
    static final CacheDisposable[] EMPTY = new CacheDisposable[0];
    static final CacheDisposable[] TERMINATED = new CacheDisposable[0];
    final SingleSource<? extends T> source;
    final AtomicInteger wip;
    final AtomicReference<CacheDisposable<T>[]> observers;
    T value;
    Throwable error;

    public SingleCache(SingleSource<? extends T> source) {
        this.source = source;
        this.wip = new AtomicInteger();
        this.observers = new AtomicReference<CacheDisposable[]>(EMPTY);
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        CacheDisposable<T> d15 = new CacheDisposable<T>(observer, this);
        observer.onSubscribe(d15);
        if (this.add(d15)) {
            if (d15.isDisposed()) {
                this.remove(d15);
            }
        } else {
            Throwable ex4 = this.error;
            if (ex4 != null) {
                observer.onError(ex4);
            } else {
                observer.onSuccess(this.value);
            }
            return;
        }
        if (this.wip.getAndIncrement() == 0) {
            this.source.subscribe(this);
        }
    }

    boolean add(CacheDisposable<T> observer) {
        CacheDisposable[] b15;
        CacheDisposable<T>[] a15;
        do {
            if ((a15 = this.observers.get()) == TERMINATED) {
                return false;
            }
            int n15 = a15.length;
            b15 = new CacheDisposable[n15 + 1];
            System.arraycopy(a15, 0, b15, 0, n15);
            b15[n15] = observer;
        } while (!this.observers.compareAndSet(a15, b15));
        return true;
    }

    void remove(CacheDisposable<T> observer) {
        CacheDisposable[] b15;
        CacheDisposable<T>[] a15;
        do {
            int n15;
            if ((n15 = (a15 = this.observers.get()).length) == 0) {
                return;
            }
            int j15 = -1;
            for (int i15 = 0; i15 < n15; ++i15) {
                if (a15[i15] != observer) continue;
                j15 = i15;
                break;
            }
            if (j15 < 0) {
                return;
            }
            if (n15 == 1) {
                b15 = EMPTY;
                continue;
            }
            b15 = new CacheDisposable[n15 - 1];
            System.arraycopy(a15, 0, b15, 0, j15);
            System.arraycopy(a15, j15 + 1, b15, j15, n15 - j15 - 1);
        } while (!this.observers.compareAndSet(a15, b15));
    }

    @Override
    public void onSubscribe(Disposable d15) {
    }

    @Override
    public void onSuccess(T value) {
        this.value = value;
        for (CacheDisposable d15 : this.observers.getAndSet(TERMINATED)) {
            if (d15.isDisposed()) continue;
            d15.downstream.onSuccess(value);
        }
    }

    @Override
    public void onError(Throwable e15) {
        this.error = e15;
        for (CacheDisposable d15 : this.observers.getAndSet(TERMINATED)) {
            if (d15.isDisposed()) continue;
            d15.downstream.onError(e15);
        }
    }

    static final class CacheDisposable<T>
    extends AtomicBoolean
    implements Disposable {
        private static final long serialVersionUID = 7514387411091976596L;
        final SingleObserver<? super T> downstream;
        final SingleCache<T> parent;

        CacheDisposable(SingleObserver<? super T> actual, SingleCache<T> parent) {
            this.downstream = actual;
            this.parent = parent;
        }

        @Override
        public boolean isDisposed() {
            return this.get();
        }

        @Override
        public void dispose() {
            if (this.compareAndSet(false, true)) {
                this.parent.remove(this);
            }
        }
    }
}

