/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.operators.observable.ObservableScalarXMap;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.QueueDisposable;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableSwitchMap<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
    final int bufferSize;
    final boolean delayErrors;

    public ObservableSwitchMap(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize, boolean delayErrors) {
        super(source);
        this.mapper = mapper;
        this.bufferSize = bufferSize;
        this.delayErrors = delayErrors;
    }

    @Override
    public void subscribeActual(Observer<? super R> t15) {
        if (ObservableScalarXMap.tryScalarXMapSubscribe(this.source, t15, this.mapper)) {
            return;
        }
        this.source.subscribe(new SwitchMapObserver<T, R>(t15, this.mapper, this.bufferSize, this.delayErrors));
    }

    static final class SwitchMapInnerObserver<T, R>
    extends AtomicReference<Disposable>
    implements Observer<R> {
        private static final long serialVersionUID = 3837284832786408377L;
        final SwitchMapObserver<T, R> parent;
        final long index;
        final int bufferSize;
        volatile SimpleQueue<R> queue;
        volatile boolean done;

        SwitchMapInnerObserver(SwitchMapObserver<T, R> parent, long index, int bufferSize) {
            this.parent = parent;
            this.index = index;
            this.bufferSize = bufferSize;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.setOnce(this, d15)) {
                if (d15 instanceof QueueDisposable) {
                    QueueDisposable qd5 = (QueueDisposable)d15;
                    int m15 = qd5.requestFusion(7);
                    if (m15 == 1) {
                        this.queue = qd5;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m15 == 2) {
                        this.queue = qd5;
                        return;
                    }
                }
                this.queue = new SpscLinkedArrayQueue<R>(this.bufferSize);
            }
        }

        @Override
        public void onNext(R t15) {
            SimpleQueue<R> q15 = this.queue;
            if (this.index == this.parent.unique && q15 != null) {
                if (t15 != null) {
                    q15.offer(t15);
                }
                this.parent.drain();
            }
        }

        @Override
        public void onError(Throwable t15) {
            this.parent.innerError(this, t15);
        }

        @Override
        public void onComplete() {
            if (this.index == this.parent.unique) {
                this.done = true;
                this.parent.drain();
            }
        }

        public void cancel() {
            DisposableHelper.dispose(this);
        }
    }

    static final class SwitchMapObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -3491074160481096299L;
        final Observer<? super R> downstream;
        final Function<? super T, ? extends ObservableSource<? extends R>> mapper;
        final int bufferSize;
        final boolean delayErrors;
        final AtomicThrowable errors;
        volatile boolean done;
        volatile boolean cancelled;
        Disposable upstream;
        final AtomicReference<SwitchMapInnerObserver<T, R>> active = new AtomicReference();
        static final SwitchMapInnerObserver<Object, Object> CANCELLED = new SwitchMapInnerObserver(null, -1L, 1);
        volatile long unique;

        SwitchMapObserver(Observer<? super R> actual, Function<? super T, ? extends ObservableSource<? extends R>> mapper, int bufferSize, boolean delayErrors) {
            this.downstream = actual;
            this.mapper = mapper;
            this.bufferSize = bufferSize;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            ObservableSource<R> p15;
            long c15;
            this.unique = c15 = this.unique + 1L;
            SwitchMapInnerObserver<T, R> inner = this.active.get();
            if (inner != null) {
                inner.cancel();
            }
            try {
                p15 = Objects.requireNonNull(this.mapper.apply(t15), "The ObservableSource returned is null");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.upstream.dispose();
                this.onError(e15);
                return;
            }
            SwitchMapInnerObserver nextInner = new SwitchMapInnerObserver(this, c15, this.bufferSize);
            while ((inner = this.active.get()) != CANCELLED) {
                if (!this.active.compareAndSet(inner, nextInner)) continue;
                p15.subscribe(nextInner);
                break;
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (!this.done && this.errors.tryAddThrowable(t15)) {
                if (!this.delayErrors) {
                    this.disposeInner();
                }
                this.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t15);
            }
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.dispose();
                this.disposeInner();
                this.errors.tryTerminateAndReport();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void disposeInner() {
            SwitchMapInnerObserver<Object, Object> a15 = this.active.getAndSet(CANCELLED);
            if (a15 != null) {
                a15.cancel();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Observer<R> a15 = this.downstream;
            AtomicReference<SwitchMapInnerObserver<T, R>> active = this.active;
            boolean delayErrors = this.delayErrors;
            int missing = 1;
            while (true) {
                SimpleQueue q15;
                SwitchMapInnerObserver<T, R> inner;
                if (this.cancelled) {
                    return;
                }
                if (this.done) {
                    Throwable ex4;
                    boolean empty;
                    boolean bl4 = empty = active.get() == null;
                    if (delayErrors) {
                        if (empty) {
                            ex4 = (Throwable)this.errors.get();
                            if (ex4 != null) {
                                a15.onError(ex4);
                            } else {
                                a15.onComplete();
                            }
                            return;
                        }
                    } else {
                        ex4 = (Throwable)this.errors.get();
                        if (ex4 != null) {
                            this.errors.tryTerminateConsumer(a15);
                            return;
                        }
                        if (empty) {
                            a15.onComplete();
                            return;
                        }
                    }
                }
                if ((inner = active.get()) != null && (q15 = inner.queue) != null) {
                    boolean retry = false;
                    while (true) {
                        boolean empty;
                        Object v15;
                        Throwable ex5;
                        if (this.cancelled) {
                            return;
                        }
                        if (inner != active.get()) {
                            retry = true;
                            break;
                        }
                        if (!delayErrors && (ex5 = (Throwable)this.errors.get()) != null) {
                            this.errors.tryTerminateConsumer(a15);
                            return;
                        }
                        boolean d15 = inner.done;
                        try {
                            v15 = q15.poll();
                        }
                        catch (Throwable ex6) {
                            Exceptions.throwIfFatal(ex6);
                            this.errors.tryAddThrowableOrReport(ex6);
                            active.compareAndSet(inner, null);
                            if (!delayErrors) {
                                this.disposeInner();
                                this.upstream.dispose();
                                this.done = true;
                            } else {
                                inner.cancel();
                            }
                            v15 = null;
                            retry = true;
                        }
                        boolean bl5 = empty = v15 == null;
                        if (d15 && empty) {
                            active.compareAndSet(inner, null);
                            retry = true;
                            break;
                        }
                        if (empty) break;
                        a15.onNext(v15);
                    }
                    if (retry) continue;
                }
                if ((missing = this.addAndGet(-missing)) == 0) break;
            }
        }

        void innerError(SwitchMapInnerObserver<T, R> inner, Throwable ex4) {
            if (inner.index == this.unique && this.errors.tryAddThrowable(ex4)) {
                if (!this.delayErrors) {
                    this.upstream.dispose();
                    this.done = true;
                }
                inner.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(ex4);
            }
        }

        static {
            CANCELLED.cancel();
        }
    }
}

