/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;

public final class ObservableScan<T>
extends AbstractObservableWithUpstream<T, T> {
    final BiFunction<T, T, T> accumulator;

    public ObservableScan(ObservableSource<T> source, BiFunction<T, T, T> accumulator) {
        super(source);
        this.accumulator = accumulator;
    }

    @Override
    public void subscribeActual(Observer<? super T> t15) {
        this.source.subscribe(new ScanObserver<T>(t15, this.accumulator));
    }

    static final class ScanObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> downstream;
        final BiFunction<T, T, T> accumulator;
        Disposable upstream;
        T value;
        boolean done;

        ScanObserver(Observer<? super T> actual, BiFunction<T, T, T> accumulator) {
            this.downstream = actual;
            this.accumulator = accumulator;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t15) {
            if (this.done) {
                return;
            }
            Observer<T> a15 = this.downstream;
            T v15 = this.value;
            if (v15 == null) {
                this.value = t15;
                a15.onNext(t15);
            } else {
                T u15;
                try {
                    u15 = Objects.requireNonNull(this.accumulator.apply(v15, t15), "The value returned by the accumulator is null");
                }
                catch (Throwable e15) {
                    Exceptions.throwIfFatal(e15);
                    this.upstream.dispose();
                    this.onError(e15);
                    return;
                }
                this.value = u15;
                a15.onNext(u15);
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            this.done = true;
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }
}

