/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableRepeat<T>
extends AbstractObservableWithUpstream<T, T> {
    final long count;

    public ObservableRepeat(Observable<T> source, long count) {
        super(source);
        this.count = count;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        SequentialDisposable sd5 = new SequentialDisposable();
        observer.onSubscribe(sd5);
        RepeatObserver<T> rs4 = new RepeatObserver<T>(observer, this.count != Long.MAX_VALUE ? this.count - 1L : Long.MAX_VALUE, sd5, this.source);
        rs4.subscribeNext();
    }

    static final class RepeatObserver<T>
    extends AtomicInteger
    implements Observer<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Observer<? super T> downstream;
        final SequentialDisposable sd;
        final ObservableSource<? extends T> source;
        long remaining;

        RepeatObserver(Observer<? super T> actual, long count, SequentialDisposable sd5, ObservableSource<? extends T> source) {
            this.downstream = actual;
            this.sd = sd5;
            this.source = source;
            this.remaining = count;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.sd.replace(d15);
        }

        @Override
        public void onNext(T t15) {
            this.downstream.onNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            long r15 = this.remaining;
            if (r15 != Long.MAX_VALUE) {
                this.remaining = r15 - 1L;
            }
            if (r15 != 0L) {
                this.subscribeNext();
            } else {
                this.downstream.onComplete();
            }
        }

        void subscribeNext() {
            block2: {
                if (this.getAndIncrement() != 0) break block2;
                int missed = 1;
                do {
                    if (this.sd.isDisposed()) {
                        return;
                    }
                    this.source.subscribe(this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

