/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableOnErrorReturn<T>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super Throwable, ? extends T> valueSupplier;

    public ObservableOnErrorReturn(ObservableSource<T> source, Function<? super Throwable, ? extends T> valueSupplier) {
        super(source);
        this.valueSupplier = valueSupplier;
    }

    @Override
    public void subscribeActual(Observer<? super T> t15) {
        this.source.subscribe(new OnErrorReturnObserver<T>(t15, this.valueSupplier));
    }

    static final class OnErrorReturnObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> downstream;
        final Function<? super Throwable, ? extends T> valueSupplier;
        Disposable upstream;

        OnErrorReturnObserver(Observer<? super T> actual, Function<? super Throwable, ? extends T> valueSupplier) {
            this.downstream = actual;
            this.valueSupplier = valueSupplier;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t15) {
            this.downstream.onNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            T v15;
            try {
                v15 = this.valueSupplier.apply(t15);
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.downstream.onError(new CompositeException(t15, e15));
                return;
            }
            if (v15 == null) {
                NullPointerException e16 = new NullPointerException("The supplied value is null");
                e16.initCause(t15);
                this.downstream.onError(e16);
                return;
            }
            this.downstream.onNext(v15);
            this.downstream.onComplete();
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

