/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableCombineLatest<T, R>
extends Observable<R> {
    final ObservableSource<? extends T>[] sources;
    final Iterable<? extends ObservableSource<? extends T>> sourcesIterable;
    final Function<? super Object[], ? extends R> combiner;
    final int bufferSize;
    final boolean delayError;

    public ObservableCombineLatest(ObservableSource<? extends T>[] sources, Iterable<? extends ObservableSource<? extends T>> sourcesIterable, Function<? super Object[], ? extends R> combiner, int bufferSize, boolean delayError) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
        this.combiner = combiner;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Observer<? super R> observer) {
        ObservableSource<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new ObservableSource[8];
            try {
                for (ObservableSource<? extends T> observableSource : this.sourcesIterable) {
                    if (count == sources.length) {
                        ObservableSource[] b15 = new ObservableSource[count + (count >> 2)];
                        System.arraycopy(sources, 0, b15, 0, count);
                        sources = b15;
                    }
                    sources[count++] = Objects.requireNonNull(observableSource, "The Iterator returned a null ObservableSource");
                }
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                EmptyDisposable.error(ex4, observer);
                return;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptyDisposable.complete(observer);
            return;
        }
        LatestCoordinator<? extends T, R> lc5 = new LatestCoordinator<T, R>(observer, this.combiner, count, this.bufferSize, this.delayError);
        lc5.subscribe(sources);
    }

    static final class CombinerObserver<T, R>
    extends AtomicReference<Disposable>
    implements Observer<T> {
        private static final long serialVersionUID = -4823716997131257941L;
        final LatestCoordinator<T, R> parent;
        final int index;

        CombinerObserver(LatestCoordinator<T, R> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            DisposableHelper.setOnce(this, d15);
        }

        @Override
        public void onNext(T t15) {
            this.parent.innerNext(this.index, t15);
        }

        @Override
        public void onError(Throwable t15) {
            this.parent.innerError(this.index, t15);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this.index);
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }
    }

    static final class LatestCoordinator<T, R>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = 8567835998786448817L;
        final Observer<? super R> downstream;
        final Function<? super Object[], ? extends R> combiner;
        final CombinerObserver<T, R>[] observers;
        Object[] latest;
        final SpscLinkedArrayQueue<Object[]> queue;
        final boolean delayError;
        volatile boolean cancelled;
        volatile boolean done;
        final AtomicThrowable errors = new AtomicThrowable();
        int active;
        int complete;

        LatestCoordinator(Observer<? super R> actual, Function<? super Object[], ? extends R> combiner, int count, int bufferSize, boolean delayError) {
            this.downstream = actual;
            this.combiner = combiner;
            this.delayError = delayError;
            this.latest = new Object[count];
            CombinerObserver[] as4 = new CombinerObserver[count];
            for (int i15 = 0; i15 < count; ++i15) {
                as4[i15] = new CombinerObserver(this, i15);
            }
            this.observers = as4;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
        }

        public void subscribe(ObservableSource<? extends T>[] sources) {
            CombinerObserver<T, R>[] as4 = this.observers;
            int len = as4.length;
            this.downstream.onSubscribe(this);
            for (int i15 = 0; i15 < len; ++i15) {
                if (this.done || this.cancelled) {
                    return;
                }
                sources[i15].subscribe(as4[i15]);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelSources();
                this.drain();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void cancelSources() {
            for (CombinerObserver<T, R> observer : this.observers) {
                observer.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear(SpscLinkedArrayQueue<?> q15) {
            LatestCoordinator latestCoordinator = this;
            synchronized (latestCoordinator) {
                this.latest = null;
            }
            q15.clear();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            SpscLinkedArrayQueue<Object[]> q15 = this.queue;
            Observer<R> a15 = this.downstream;
            boolean delayError = this.delayError;
            int missed = 1;
            while (true) {
                boolean empty;
                if (this.cancelled) {
                    this.clear(q15);
                    this.errors.tryTerminateAndReport();
                    return;
                }
                if (!delayError && this.errors.get() != null) {
                    this.cancelSources();
                    this.clear(q15);
                    this.errors.tryTerminateConsumer(a15);
                    return;
                }
                boolean d15 = this.done;
                Object[] s15 = q15.poll();
                boolean bl4 = empty = s15 == null;
                if (d15 && empty) {
                    this.clear(q15);
                    this.errors.tryTerminateConsumer(a15);
                    return;
                }
                if (!empty) {
                    R v15;
                    try {
                        v15 = Objects.requireNonNull(this.combiner.apply((Object[])s15), "The combiner returned a null value");
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        this.errors.tryAddThrowableOrReport(ex4);
                        this.cancelSources();
                        this.clear(q15);
                        this.errors.tryTerminateConsumer(a15);
                        return;
                    }
                    a15.onNext(v15);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerNext(int index, T item) {
            boolean shouldDrain = false;
            LatestCoordinator latestCoordinator = this;
            synchronized (latestCoordinator) {
                Object[] latest = this.latest;
                if (latest == null) {
                    return;
                }
                Object o15 = latest[index];
                int a15 = this.active;
                if (o15 == null) {
                    this.active = ++a15;
                }
                latest[index] = item;
                if (a15 == latest.length) {
                    this.queue.offer((Object[])latest.clone());
                    shouldDrain = true;
                }
            }
            if (shouldDrain) {
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerError(int index, Throwable ex4) {
            if (this.errors.tryAddThrowableOrReport(ex4)) {
                boolean cancelOthers = true;
                if (this.delayError) {
                    LatestCoordinator latestCoordinator = this;
                    synchronized (latestCoordinator) {
                        Object[] latest = this.latest;
                        if (latest == null) {
                            return;
                        }
                        boolean bl4 = cancelOthers = latest[index] == null;
                        if (cancelOthers || ++this.complete == latest.length) {
                            this.done = true;
                        }
                    }
                }
                if (cancelOthers) {
                    this.cancelSources();
                }
                this.drain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerComplete(int index) {
            boolean cancelOthers = false;
            LatestCoordinator latestCoordinator = this;
            synchronized (latestCoordinator) {
                Object[] latest = this.latest;
                if (latest == null) {
                    return;
                }
                boolean bl4 = cancelOthers = latest[index] == null;
                if (cancelOthers || ++this.complete == latest.length) {
                    this.done = true;
                }
            }
            if (cancelOthers) {
                this.cancelSources();
            }
            this.drain();
        }
    }
}

