/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.operators.maybe.MaybeMap;
import io.reactivex.rxjava3.internal.operators.maybe.MaybeZipArray;
import java.util.Arrays;
import java.util.Objects;

public final class MaybeZipIterable<T, R>
extends Maybe<R> {
    final Iterable<? extends MaybeSource<? extends T>> sources;
    final Function<? super Object[], ? extends R> zipper;

    public MaybeZipIterable(Iterable<? extends MaybeSource<? extends T>> sources, Function<? super Object[], ? extends R> zipper) {
        this.sources = sources;
        this.zipper = zipper;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void subscribeActual(MaybeObserver<? super R> observer) {
        void var5_8;
        MaybeSource[] a15 = new MaybeSource[8];
        int n15 = 0;
        try {
            for (MaybeSource<? extends T> maybeSource : this.sources) {
                if (maybeSource == null) {
                    EmptyDisposable.error((Throwable)new NullPointerException("One of the sources is null"), observer);
                    return;
                }
                if (n15 == a15.length) {
                    a15 = Arrays.copyOf(a15, n15 + (n15 >> 2));
                }
                a15[n15++] = maybeSource;
            }
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            EmptyDisposable.error(ex4, observer);
            return;
        }
        if (n15 == 0) {
            EmptyDisposable.complete(observer);
            return;
        }
        if (n15 == 1) {
            a15[0].subscribe(new MaybeMap.MapMaybeObserver(observer, new SingletonArrayFunc()));
            return;
        }
        MaybeZipArray.ZipCoordinator parent = new MaybeZipArray.ZipCoordinator(observer, n15, this.zipper);
        observer.onSubscribe(parent);
        boolean bl4 = false;
        while (var5_8 < n15) {
            if (parent.isDisposed()) {
                return;
            }
            a15[var5_8].subscribe(parent.observers[var5_8]);
            ++var5_8;
        }
    }

    final class SingletonArrayFunc
    implements Function<T, R> {
        SingletonArrayFunc() {
        }

        @Override
        public R apply(T t15) throws Throwable {
            return Objects.requireNonNull(MaybeZipIterable.this.zipper.apply((Object[])new Object[]{t15}), "The zipper returned a null value");
        }
    }
}

