/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.maybe.AbstractMaybeWithUpstream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeFlatMapBiSelector<T, U, R>
extends AbstractMaybeWithUpstream<T, R> {
    final Function<? super T, ? extends MaybeSource<? extends U>> mapper;
    final BiFunction<? super T, ? super U, ? extends R> resultSelector;

    public MaybeFlatMapBiSelector(MaybeSource<T> source, Function<? super T, ? extends MaybeSource<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> resultSelector) {
        super(source);
        this.mapper = mapper;
        this.resultSelector = resultSelector;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super R> observer) {
        this.source.subscribe(new FlatMapBiMainObserver<T, U, R>(observer, this.mapper, this.resultSelector));
    }

    static final class FlatMapBiMainObserver<T, U, R>
    implements MaybeObserver<T>,
    Disposable {
        final Function<? super T, ? extends MaybeSource<? extends U>> mapper;
        final InnerObserver<T, U, R> inner;

        FlatMapBiMainObserver(MaybeObserver<? super R> actual, Function<? super T, ? extends MaybeSource<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> resultSelector) {
            this.inner = new InnerObserver<T, U, R>(actual, resultSelector);
            this.mapper = mapper;
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.inner);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.inner.get());
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.setOnce(this.inner, d15)) {
                this.inner.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            MaybeSource<U> next;
            try {
                next = Objects.requireNonNull(this.mapper.apply(value), "The mapper returned a null MaybeSource");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.inner.downstream.onError(ex4);
                return;
            }
            if (DisposableHelper.replace(this.inner, null)) {
                this.inner.value = value;
                next.subscribe(this.inner);
            }
        }

        @Override
        public void onError(Throwable e15) {
            this.inner.downstream.onError(e15);
        }

        @Override
        public void onComplete() {
            this.inner.downstream.onComplete();
        }

        static final class InnerObserver<T, U, R>
        extends AtomicReference<Disposable>
        implements MaybeObserver<U> {
            private static final long serialVersionUID = -2897979525538174559L;
            final MaybeObserver<? super R> downstream;
            final BiFunction<? super T, ? super U, ? extends R> resultSelector;
            T value;

            InnerObserver(MaybeObserver<? super R> actual, BiFunction<? super T, ? super U, ? extends R> resultSelector) {
                this.downstream = actual;
                this.resultSelector = resultSelector;
            }

            @Override
            public void onSubscribe(Disposable d15) {
                DisposableHelper.setOnce(this, d15);
            }

            @Override
            public void onSuccess(U value) {
                R r15;
                T t15 = this.value;
                this.value = null;
                try {
                    r15 = Objects.requireNonNull(this.resultSelector.apply(t15, value), "The resultSelector returned a null value");
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.downstream.onError(ex4);
                    return;
                }
                this.downstream.onSuccess(r15);
            }

            @Override
            public void onError(Throwable e15) {
                this.downstream.onError(e15);
            }

            @Override
            public void onComplete() {
                this.downstream.onComplete();
            }
        }
    }
}

