/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableTimer
extends Flowable<Long> {
    final Scheduler scheduler;
    final long delay;
    final TimeUnit unit;

    public FlowableTimer(long delay, TimeUnit unit, Scheduler scheduler) {
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    public void subscribeActual(Subscriber<? super Long> s15) {
        TimerSubscriber ios = new TimerSubscriber(s15);
        s15.onSubscribe(ios);
        Disposable d15 = this.scheduler.scheduleDirect(ios, this.delay, this.unit);
        ios.setResource(d15);
    }

    static final class TimerSubscriber
    extends AtomicReference<Disposable>
    implements Subscription,
    Runnable {
        private static final long serialVersionUID = -2809475196591179431L;
        final Subscriber<? super Long> downstream;
        volatile boolean requested;

        TimerSubscriber(Subscriber<? super Long> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                this.requested = true;
            }
        }

        @Override
        public void cancel() {
            DisposableHelper.dispose(this);
        }

        @Override
        public void run() {
            if (this.get() != DisposableHelper.DISPOSED) {
                if (this.requested) {
                    this.downstream.onNext((Long)0L);
                    this.lazySet(EmptyDisposable.INSTANCE);
                    this.downstream.onComplete();
                } else {
                    this.lazySet(EmptyDisposable.INSTANCE);
                    this.downstream.onError(MissingBackpressureException.createDefault());
                }
            }
        }

        public void setResource(Disposable d15) {
            DisposableHelper.trySet(this, d15);
        }
    }
}

