/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSkip<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long n;

    public FlowableSkip(Flowable<T> source, long n15) {
        super(source);
        this.n = n15;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        this.source.subscribe(new SkipSubscriber<T>(s15, this.n));
    }

    static final class SkipSubscriber<T>
    implements FlowableSubscriber<T>,
    Subscription {
        final Subscriber<? super T> downstream;
        long remaining;
        Subscription upstream;

        SkipSubscriber(Subscriber<? super T> actual, long n15) {
            this.downstream = actual;
            this.remaining = n15;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                long n15 = this.remaining;
                this.upstream = s15;
                this.downstream.onSubscribe(this);
                s15.request(n15);
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.remaining != 0L) {
                --this.remaining;
            } else {
                this.downstream.onNext(t15);
            }
        }

        @Override
        public void onError(Throwable t15) {
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void request(long n15) {
            this.upstream.request(n15);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }
    }
}

