/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.internal.subscriptions.BasicQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import org.reactivestreams.Subscriber;

public final class FlowableRange
extends Flowable<Integer> {
    final int start;
    final int end;

    public FlowableRange(int start, int count) {
        this.start = start;
        this.end = start + count;
    }

    @Override
    public void subscribeActual(Subscriber<? super Integer> s15) {
        if (s15 instanceof ConditionalSubscriber) {
            s15.onSubscribe(new RangeConditionalSubscription((ConditionalSubscriber)s15, this.start, this.end));
        } else {
            s15.onSubscribe(new RangeSubscription(s15, this.start, this.end));
        }
    }

    static final class RangeConditionalSubscription
    extends BaseRangeSubscription {
        private static final long serialVersionUID = 2587302975077663557L;
        final ConditionalSubscriber<? super Integer> downstream;

        RangeConditionalSubscription(ConditionalSubscriber<? super Integer> actual, int index, int end) {
            super(index, end);
            this.downstream = actual;
        }

        @Override
        void fastPath() {
            int f15 = this.end;
            ConditionalSubscriber<? super Integer> a15 = this.downstream;
            for (int i15 = this.index; i15 != f15; ++i15) {
                if (this.cancelled) {
                    return;
                }
                a15.tryOnNext((Integer)i15);
            }
            if (this.cancelled) {
                return;
            }
            a15.onComplete();
        }

        @Override
        void slowPath(long r15) {
            long e15 = 0L;
            int f15 = this.end;
            int i15 = this.index;
            ConditionalSubscriber<? super Integer> a15 = this.downstream;
            while (true) {
                if (e15 != r15 && i15 != f15) {
                    if (this.cancelled) {
                        return;
                    }
                    if (a15.tryOnNext((Integer)i15)) {
                        ++e15;
                    }
                    ++i15;
                    continue;
                }
                if (i15 == f15) {
                    if (!this.cancelled) {
                        a15.onComplete();
                    }
                    return;
                }
                r15 = this.get();
                if (e15 != r15) continue;
                this.index = i15;
                r15 = this.addAndGet(-e15);
                if (r15 == 0L) {
                    return;
                }
                e15 = 0L;
            }
        }
    }

    static final class RangeSubscription
    extends BaseRangeSubscription {
        private static final long serialVersionUID = 2587302975077663557L;
        final Subscriber<? super Integer> downstream;

        RangeSubscription(Subscriber<? super Integer> actual, int index, int end) {
            super(index, end);
            this.downstream = actual;
        }

        @Override
        void fastPath() {
            int f15 = this.end;
            Subscriber<? super Integer> a15 = this.downstream;
            for (int i15 = this.index; i15 != f15; ++i15) {
                if (this.cancelled) {
                    return;
                }
                a15.onNext((Integer)i15);
            }
            if (this.cancelled) {
                return;
            }
            a15.onComplete();
        }

        @Override
        void slowPath(long r15) {
            long e15 = 0L;
            int f15 = this.end;
            int i15 = this.index;
            Subscriber<? super Integer> a15 = this.downstream;
            while (true) {
                if (e15 != r15 && i15 != f15) {
                    if (this.cancelled) {
                        return;
                    }
                    a15.onNext((Integer)i15);
                    ++e15;
                    ++i15;
                    continue;
                }
                if (i15 == f15) {
                    if (!this.cancelled) {
                        a15.onComplete();
                    }
                    return;
                }
                r15 = this.get();
                if (e15 != r15) continue;
                this.index = i15;
                r15 = this.addAndGet(-e15);
                if (r15 == 0L) {
                    return;
                }
                e15 = 0L;
            }
        }
    }

    static abstract class BaseRangeSubscription
    extends BasicQueueSubscription<Integer> {
        private static final long serialVersionUID = -2252972430506210021L;
        final int end;
        int index;
        volatile boolean cancelled;

        BaseRangeSubscription(int index, int end) {
            this.index = index;
            this.end = end;
        }

        @Override
        public final int requestFusion(int mode) {
            return mode & 1;
        }

        @Override
        @Nullable
        public final Integer poll() {
            int i15 = this.index;
            if (i15 == this.end) {
                return null;
            }
            this.index = i15 + 1;
            return i15;
        }

        @Override
        public final boolean isEmpty() {
            return this.index == this.end;
        }

        @Override
        public final void clear() {
            this.index = this.end;
        }

        @Override
        public final void request(long n15) {
            if (SubscriptionHelper.validate(n15) && BackpressureHelper.add(this, n15) == 0L) {
                if (n15 == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n15);
                }
            }
        }

        @Override
        public final void cancel() {
            this.cancelled = true;
        }

        abstract void fastPath();

        abstract void slowPath(long var1);
    }
}

