/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.QueueOverflowException;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableScalarXMap;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionArbiter;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.internal.util.HalfSerializer;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableConcatMap<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int prefetch;
    final ErrorMode errorMode;

    public FlowableConcatMap(Flowable<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
        super(source);
        this.mapper = mapper;
        this.prefetch = prefetch;
        this.errorMode = errorMode;
    }

    public static <T, R> Subscriber<T> subscribe(Subscriber<? super R> s15, Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, ErrorMode errorMode) {
        switch (errorMode) {
            case BOUNDARY: {
                return new ConcatMapDelayed<T, R>(s15, mapper, prefetch, false);
            }
            case END: {
                return new ConcatMapDelayed<T, R>(s15, mapper, prefetch, true);
            }
        }
        return new ConcatMapImmediate<T, R>(s15, mapper, prefetch);
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s15) {
        if (FlowableScalarXMap.tryScalarXMapSubscribe(this.source, s15, this.mapper)) {
            return;
        }
        this.source.subscribe(FlowableConcatMap.subscribe(s15, this.mapper, this.prefetch, this.errorMode));
    }

    static final class ConcatMapInner<R>
    extends SubscriptionArbiter
    implements FlowableSubscriber<R> {
        private static final long serialVersionUID = 897683679971470653L;
        final ConcatMapSupport<R> parent;
        long produced;

        ConcatMapInner(ConcatMapSupport<R> parent) {
            super(false);
            this.parent = parent;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            this.setSubscription(s15);
        }

        @Override
        public void onNext(R t15) {
            ++this.produced;
            this.parent.innerNext(t15);
        }

        @Override
        public void onError(Throwable t15) {
            long p15 = this.produced;
            if (p15 != 0L) {
                this.produced = 0L;
                this.produced(p15);
            }
            this.parent.innerError(t15);
        }

        @Override
        public void onComplete() {
            long p15 = this.produced;
            if (p15 != 0L) {
                this.produced = 0L;
                this.produced(p15);
            }
            this.parent.innerComplete();
        }
    }

    static interface ConcatMapSupport<T> {
        public void innerNext(T var1);

        public void innerComplete();

        public void innerError(Throwable var1);
    }

    static final class ConcatMapDelayed<T, R>
    extends BaseConcatMapSubscriber<T, R> {
        private static final long serialVersionUID = -2945777694260521066L;
        final Subscriber<? super R> downstream;
        final boolean veryEnd;

        ConcatMapDelayed(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, boolean veryEnd) {
            super(mapper, prefetch);
            this.downstream = actual;
            this.veryEnd = veryEnd;
        }

        @Override
        void subscribeActual() {
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onError(Throwable t15) {
            if (this.errors.tryAddThrowableOrReport(t15)) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void innerNext(R value) {
            this.downstream.onNext(value);
        }

        @Override
        public void innerError(Throwable e15) {
            if (this.errors.tryAddThrowableOrReport(e15)) {
                if (!this.veryEnd) {
                    this.upstream.cancel();
                    this.done = true;
                }
                this.active = false;
                this.drain();
            }
        }

        @Override
        public void request(long n15) {
            this.inner.request(n15);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.inner.cancel();
                this.upstream.cancel();
                this.errors.tryTerminateAndReport();
            }
        }

        @Override
        void drain() {
            block19: {
                if (this.getAndIncrement() != 0) break block19;
                while (true) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.active) {
                        boolean empty;
                        Object v15;
                        Throwable ex4;
                        boolean d15 = this.done;
                        if (d15 && !this.veryEnd && (ex4 = (Throwable)this.errors.get()) != null) {
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        try {
                            v15 = this.queue.poll();
                        }
                        catch (Throwable e15) {
                            Exceptions.throwIfFatal(e15);
                            this.upstream.cancel();
                            this.errors.tryAddThrowableOrReport(e15);
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        boolean bl4 = empty = v15 == null;
                        if (d15 && empty) {
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        if (!empty) {
                            Publisher p15;
                            try {
                                p15 = (Publisher)Objects.requireNonNull(this.mapper.apply(v15), "The mapper returned a null Publisher");
                            }
                            catch (Throwable e16) {
                                Exceptions.throwIfFatal(e16);
                                this.upstream.cancel();
                                this.errors.tryAddThrowableOrReport(e16);
                                this.errors.tryTerminateConsumer(this.downstream);
                                return;
                            }
                            if (this.sourceMode != 1) {
                                int c15 = this.consumed + 1;
                                if (c15 == this.limit) {
                                    this.consumed = 0;
                                    this.upstream.request(c15);
                                } else {
                                    this.consumed = c15;
                                }
                            }
                            if (p15 instanceof Supplier) {
                                Object vr4;
                                Supplier supplier = (Supplier)((Object)p15);
                                try {
                                    vr4 = supplier.get();
                                }
                                catch (Throwable e17) {
                                    Exceptions.throwIfFatal(e17);
                                    this.errors.tryAddThrowableOrReport(e17);
                                    if (!this.veryEnd) {
                                        this.upstream.cancel();
                                        this.errors.tryTerminateConsumer(this.downstream);
                                        return;
                                    }
                                    vr4 = null;
                                }
                                if (vr4 == null) continue;
                                if (this.inner.isUnbounded()) {
                                    this.downstream.onNext(vr4);
                                    continue;
                                }
                                this.active = true;
                                this.inner.setSubscription(new SimpleScalarSubscription(vr4, this.inner));
                            } else {
                                this.active = true;
                                p15.subscribe(this.inner);
                            }
                        }
                    }
                    if (this.decrementAndGet() == 0) break;
                }
            }
        }
    }

    static final class SimpleScalarSubscription<T>
    extends AtomicBoolean
    implements Subscription {
        private static final long serialVersionUID = -7606889335172043256L;
        final Subscriber<? super T> downstream;
        final T value;

        SimpleScalarSubscription(T value, Subscriber<? super T> downstream) {
            this.value = value;
            this.downstream = downstream;
        }

        @Override
        public void request(long n15) {
            if (n15 > 0L && this.compareAndSet(false, true)) {
                Subscriber<T> a15 = this.downstream;
                a15.onNext(this.value);
                a15.onComplete();
            }
        }

        @Override
        public void cancel() {
        }
    }

    static final class ConcatMapImmediate<T, R>
    extends BaseConcatMapSubscriber<T, R> {
        private static final long serialVersionUID = 7898995095634264146L;
        final Subscriber<? super R> downstream;
        final AtomicInteger wip;

        ConcatMapImmediate(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch) {
            super(mapper, prefetch);
            this.downstream = actual;
            this.wip = new AtomicInteger();
        }

        @Override
        void subscribeActual() {
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onError(Throwable t15) {
            this.inner.cancel();
            HalfSerializer.onError(this.downstream, t15, (AtomicInteger)this, this.errors);
        }

        @Override
        public void innerNext(R value) {
            HalfSerializer.onNext(this.downstream, value, (AtomicInteger)this, this.errors);
        }

        @Override
        public void innerError(Throwable e15) {
            this.upstream.cancel();
            HalfSerializer.onError(this.downstream, e15, (AtomicInteger)this, this.errors);
        }

        @Override
        public void request(long n15) {
            this.inner.request(n15);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.inner.cancel();
                this.upstream.cancel();
                this.errors.tryTerminateAndReport();
            }
        }

        @Override
        void drain() {
            block17: {
                if (this.wip.getAndIncrement() != 0) break block17;
                while (true) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.active) {
                        boolean empty;
                        Object v15;
                        boolean d15 = this.done;
                        try {
                            v15 = this.queue.poll();
                        }
                        catch (Throwable e15) {
                            Exceptions.throwIfFatal(e15);
                            this.upstream.cancel();
                            this.errors.tryAddThrowableOrReport(e15);
                            this.errors.tryTerminateConsumer(this.downstream);
                            return;
                        }
                        boolean bl4 = empty = v15 == null;
                        if (d15 && empty) {
                            this.downstream.onComplete();
                            return;
                        }
                        if (!empty) {
                            Publisher p15;
                            try {
                                p15 = (Publisher)Objects.requireNonNull(this.mapper.apply(v15), "The mapper returned a null Publisher");
                            }
                            catch (Throwable e16) {
                                Exceptions.throwIfFatal(e16);
                                this.upstream.cancel();
                                this.errors.tryAddThrowableOrReport(e16);
                                this.errors.tryTerminateConsumer(this.downstream);
                                return;
                            }
                            if (this.sourceMode != 1) {
                                int c15 = this.consumed + 1;
                                if (c15 == this.limit) {
                                    this.consumed = 0;
                                    this.upstream.request(c15);
                                } else {
                                    this.consumed = c15;
                                }
                            }
                            if (p15 instanceof Supplier) {
                                Object vr4;
                                Supplier supplier = (Supplier)((Object)p15);
                                try {
                                    vr4 = supplier.get();
                                }
                                catch (Throwable e17) {
                                    Exceptions.throwIfFatal(e17);
                                    this.upstream.cancel();
                                    this.errors.tryAddThrowableOrReport(e17);
                                    this.errors.tryTerminateConsumer(this.downstream);
                                    return;
                                }
                                if (vr4 == null) continue;
                                if (this.inner.isUnbounded()) {
                                    if (HalfSerializer.onNext(this.downstream, vr4, (AtomicInteger)this, this.errors)) continue;
                                    return;
                                }
                                this.active = true;
                                this.inner.setSubscription(new SimpleScalarSubscription(vr4, this.inner));
                            } else {
                                this.active = true;
                                p15.subscribe(this.inner);
                            }
                        }
                    }
                    if (this.wip.decrementAndGet() == 0) break;
                }
            }
        }
    }

    static abstract class BaseConcatMapSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    ConcatMapSupport<R>,
    Subscription {
        private static final long serialVersionUID = -3511336836796789179L;
        final ConcatMapInner<R> inner;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final int prefetch;
        final int limit;
        Subscription upstream;
        int consumed;
        SimpleQueue<T> queue;
        volatile boolean done;
        volatile boolean cancelled;
        final AtomicThrowable errors;
        volatile boolean active;
        int sourceMode;

        BaseConcatMapSubscriber(Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch) {
            this.mapper = mapper;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.inner = new ConcatMapInner(this);
            this.errors = new AtomicThrowable();
        }

        @Override
        public final void onSubscribe(Subscription s15) {
            if (SubscriptionHelper.validate(this.upstream, s15)) {
                this.upstream = s15;
                if (s15 instanceof QueueSubscription) {
                    QueueSubscription f15 = (QueueSubscription)s15;
                    int m15 = f15.requestFusion(7);
                    if (m15 == 1) {
                        this.sourceMode = m15;
                        this.queue = f15;
                        this.done = true;
                        this.subscribeActual();
                        this.drain();
                        return;
                    }
                    if (m15 == 2) {
                        this.sourceMode = m15;
                        this.queue = f15;
                        this.subscribeActual();
                        s15.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                this.subscribeActual();
                s15.request(this.prefetch);
            }
        }

        abstract void drain();

        abstract void subscribeActual();

        @Override
        public final void onNext(T t15) {
            if (this.sourceMode != 2 && !this.queue.offer(t15)) {
                this.upstream.cancel();
                this.onError(new QueueOverflowException());
                return;
            }
            this.drain();
        }

        @Override
        public final void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public final void innerComplete() {
            this.active = false;
            this.drain();
        }
    }
}

