/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Predicate;

public final class CompletableOnErrorComplete
extends Completable {
    final CompletableSource source;
    final Predicate<? super Throwable> predicate;

    public CompletableOnErrorComplete(CompletableSource source, Predicate<? super Throwable> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe(new OnError(observer, this.predicate));
    }

    static final class OnError
    implements CompletableObserver {
        private final CompletableObserver downstream;
        private final Predicate<? super Throwable> predicate;

        OnError(CompletableObserver observer, Predicate<? super Throwable> predicate) {
            this.downstream = observer;
            this.predicate = predicate;
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void onError(Throwable e15) {
            boolean b15;
            try {
                b15 = this.predicate.test(e15);
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.downstream.onError(new CompositeException(e15, ex4));
                return;
            }
            if (b15) {
                this.downstream.onComplete();
            } else {
                this.downstream.onError(e15);
            }
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.downstream.onSubscribe(d15);
        }
    }
}

