/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.util.BlockingHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class BlockingMultiObserver<T>
extends CountDownLatch
implements SingleObserver<T>,
CompletableObserver,
MaybeObserver<T> {
    T value;
    Throwable error;
    Disposable upstream;
    volatile boolean cancelled;

    public BlockingMultiObserver() {
        super(1);
    }

    void dispose() {
        this.cancelled = true;
        Disposable d15 = this.upstream;
        if (d15 != null) {
            d15.dispose();
        }
    }

    @Override
    public void onSubscribe(Disposable d15) {
        this.upstream = d15;
        if (this.cancelled) {
            d15.dispose();
        }
    }

    @Override
    public void onSuccess(T value) {
        this.value = value;
        this.countDown();
    }

    @Override
    public void onError(Throwable e15) {
        this.error = e15;
        this.countDown();
    }

    @Override
    public void onComplete() {
        this.countDown();
    }

    public T blockingGet() {
        Throwable ex4;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex5) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex5);
            }
        }
        if ((ex4 = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(ex4);
        }
        return this.value;
    }

    public T blockingGet(T defaultValue) {
        Throwable ex4;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex5) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex5);
            }
        }
        if ((ex4 = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(ex4);
        }
        T v15 = this.value;
        return v15 != null ? v15 : defaultValue;
    }

    public boolean blockingAwait(long timeout, TimeUnit unit) {
        Throwable ex4;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                if (!this.await(timeout, unit)) {
                    this.dispose();
                    return false;
                }
            }
            catch (InterruptedException ex5) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex5);
            }
        }
        if ((ex4 = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(ex4);
        }
        return true;
    }

    public void blockingConsume(Consumer<? super T> onSuccess, Consumer<? super Throwable> onError, Action onComplete) {
        try {
            Throwable ex4;
            if (this.getCount() != 0L) {
                try {
                    BlockingHelper.verifyNonBlocking();
                    this.await();
                }
                catch (InterruptedException ex5) {
                    this.dispose();
                    onError.accept(ex5);
                    return;
                }
            }
            if ((ex4 = this.error) != null) {
                onError.accept(ex4);
                return;
            }
            T v15 = this.value;
            if (v15 != null) {
                onSuccess.accept(v15);
            } else {
                onComplete.run();
            }
        }
        catch (Throwable t15) {
            Exceptions.throwIfFatal(t15);
            RxJavaPlugins.onError(t15);
        }
    }
}

