/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.operators.QueueDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

public final class ObservableFromStream<T>
extends Observable<T> {
    final Stream<T> stream;

    public ObservableFromStream(Stream<T> stream) {
        this.stream = stream;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        ObservableFromStream.subscribeStream(observer, this.stream);
    }

    public static <T> void subscribeStream(Observer<? super T> observer, Stream<T> stream) {
        Iterator iterator2;
        try {
            iterator2 = stream.iterator();
            if (!iterator2.hasNext()) {
                EmptyDisposable.complete(observer);
                ObservableFromStream.closeSafely(stream);
                return;
            }
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            EmptyDisposable.error(ex4, observer);
            ObservableFromStream.closeSafely(stream);
            return;
        }
        StreamDisposable<T> disposable = new StreamDisposable<T>(observer, iterator2, stream);
        observer.onSubscribe(disposable);
        disposable.run();
    }

    static void closeSafely(AutoCloseable c15) {
        try {
            c15.close();
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            RxJavaPlugins.onError(ex4);
        }
    }

    static final class StreamDisposable<T>
    implements QueueDisposable<T> {
        final Observer<? super T> downstream;
        Iterator<T> iterator;
        AutoCloseable closeable;
        volatile boolean disposed;
        boolean once;
        boolean outputFused;

        StreamDisposable(Observer<? super T> downstream, Iterator<T> iterator2, AutoCloseable closeable) {
            this.downstream = downstream;
            this.iterator = iterator2;
            this.closeable = closeable;
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.run();
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 1) != 0) {
                this.outputFused = true;
                return 1;
            }
            return 0;
        }

        @Override
        public boolean offer(@NonNull T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offer(@NonNull T v15, @NonNull T v25) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public T poll() {
            if (this.iterator == null) {
                return null;
            }
            if (!this.once) {
                this.once = true;
            } else if (!this.iterator.hasNext()) {
                this.clear();
                return null;
            }
            return Objects.requireNonNull(this.iterator.next(), "The Stream's Iterator.next() returned a null value");
        }

        @Override
        public boolean isEmpty() {
            Iterator<T> it = this.iterator;
            if (it != null) {
                if (!this.once || it.hasNext()) {
                    return false;
                }
                this.clear();
            }
            return true;
        }

        @Override
        public void clear() {
            this.iterator = null;
            AutoCloseable c15 = this.closeable;
            this.closeable = null;
            if (c15 != null) {
                ObservableFromStream.closeSafely(c15);
            }
        }

        public void run() {
            if (this.outputFused) {
                return;
            }
            Iterator<T> iterator2 = this.iterator;
            Observer<T> downstream = this.downstream;
            while (true) {
                block7: {
                    T next;
                    if (this.disposed) break;
                    try {
                        next = Objects.requireNonNull(iterator2.next(), "The Stream's Iterator.next returned a null value");
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        downstream.onError(ex4);
                        this.disposed = true;
                        continue;
                    }
                    if (this.disposed) continue;
                    downstream.onNext(next);
                    if (this.disposed) continue;
                    try {
                        if (iterator2.hasNext()) {
                        }
                        break block7;
                    }
                    catch (Throwable ex5) {
                        Exceptions.throwIfFatal(ex5);
                        downstream.onError(ex5);
                        this.disposed = true;
                    }
                    continue;
                }
                downstream.onComplete();
                this.disposed = true;
            }
            this.clear();
        }
    }
}

