/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.reactivestreams.Subscriber;

public final class FlowableFromStream<T>
extends Flowable<T> {
    final Stream<T> stream;

    public FlowableFromStream(Stream<T> stream) {
        this.stream = stream;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        FlowableFromStream.subscribeStream(s15, this.stream);
    }

    public static <T> void subscribeStream(Subscriber<? super T> s15, Stream<T> stream) {
        Iterator iterator2;
        try {
            iterator2 = stream.iterator();
            if (!iterator2.hasNext()) {
                EmptySubscription.complete(s15);
                FlowableFromStream.closeSafely(stream);
                return;
            }
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            EmptySubscription.error(ex4, s15);
            FlowableFromStream.closeSafely(stream);
            return;
        }
        if (s15 instanceof ConditionalSubscriber) {
            s15.onSubscribe(new StreamConditionalSubscription((ConditionalSubscriber)s15, iterator2, stream));
        } else {
            s15.onSubscribe(new StreamSubscription<T>(s15, iterator2, stream));
        }
    }

    static void closeSafely(AutoCloseable c15) {
        try {
            c15.close();
        }
        catch (Throwable ex4) {
            Exceptions.throwIfFatal(ex4);
            RxJavaPlugins.onError(ex4);
        }
    }

    static final class StreamConditionalSubscription<T>
    extends AbstractStreamSubscription<T> {
        private static final long serialVersionUID = -9082954702547571853L;
        final ConditionalSubscriber<? super T> downstream;

        StreamConditionalSubscription(ConditionalSubscriber<? super T> downstream, Iterator<T> iterator2, AutoCloseable closeable) {
            super(iterator2, closeable);
            this.downstream = downstream;
        }

        @Override
        public void run(long n15) {
            long emitted = 0L;
            Iterator iterator2 = this.iterator;
            ConditionalSubscriber downstream = this.downstream;
            while (true) {
                block8: {
                    Object next;
                    if (this.cancelled) {
                        this.clear();
                        break;
                    }
                    try {
                        next = Objects.requireNonNull(iterator2.next(), "The Stream's Iterator returned a null value");
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        downstream.onError(ex4);
                        this.cancelled = true;
                        continue;
                    }
                    if (downstream.tryOnNext(next)) {
                        ++emitted;
                    }
                    if (this.cancelled) continue;
                    try {
                        if (!iterator2.hasNext()) {
                            downstream.onComplete();
                            this.cancelled = true;
                        }
                        break block8;
                    }
                    catch (Throwable ex5) {
                        Exceptions.throwIfFatal(ex5);
                        downstream.onError(ex5);
                        this.cancelled = true;
                    }
                    continue;
                }
                if (emitted != n15 || emitted != (n15 = this.get())) continue;
                if (this.compareAndSet(n15, 0L)) break;
                n15 = this.get();
            }
        }
    }

    static final class StreamSubscription<T>
    extends AbstractStreamSubscription<T> {
        private static final long serialVersionUID = -9082954702547571853L;
        final Subscriber<? super T> downstream;

        StreamSubscription(Subscriber<? super T> downstream, Iterator<T> iterator2, AutoCloseable closeable) {
            super(iterator2, closeable);
            this.downstream = downstream;
        }

        @Override
        public void run(long n15) {
            long emitted = 0L;
            Iterator iterator2 = this.iterator;
            Subscriber downstream = this.downstream;
            while (true) {
                block7: {
                    Object next;
                    if (this.cancelled) {
                        this.clear();
                        break;
                    }
                    try {
                        next = Objects.requireNonNull(iterator2.next(), "The Stream's Iterator returned a null value");
                    }
                    catch (Throwable ex4) {
                        Exceptions.throwIfFatal(ex4);
                        downstream.onError(ex4);
                        this.cancelled = true;
                        continue;
                    }
                    downstream.onNext(next);
                    if (this.cancelled) continue;
                    try {
                        if (!iterator2.hasNext()) {
                            downstream.onComplete();
                            this.cancelled = true;
                        }
                        break block7;
                    }
                    catch (Throwable ex5) {
                        Exceptions.throwIfFatal(ex5);
                        downstream.onError(ex5);
                        this.cancelled = true;
                    }
                    continue;
                }
                if (++emitted != n15 || emitted != (n15 = this.get())) continue;
                if (this.compareAndSet(n15, 0L)) break;
                n15 = this.get();
            }
        }
    }

    static abstract class AbstractStreamSubscription<T>
    extends AtomicLong
    implements QueueSubscription<T> {
        private static final long serialVersionUID = -9082954702547571853L;
        Iterator<T> iterator;
        AutoCloseable closeable;
        volatile boolean cancelled;
        boolean once;

        AbstractStreamSubscription(Iterator<T> iterator2, AutoCloseable closeable) {
            this.iterator = iterator2;
            this.closeable = closeable;
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15) && BackpressureHelper.add(this, n15) == 0L) {
                this.run(n15);
            }
        }

        abstract void run(long var1);

        @Override
        public void cancel() {
            this.cancelled = true;
            this.request(1L);
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 1) != 0) {
                this.lazySet(Long.MAX_VALUE);
                return 1;
            }
            return 0;
        }

        @Override
        public boolean offer(@NonNull T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offer(@NonNull T v15, @NonNull T v25) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public T poll() {
            if (this.iterator == null) {
                return null;
            }
            if (!this.once) {
                this.once = true;
            } else if (!this.iterator.hasNext()) {
                this.clear();
                return null;
            }
            return Objects.requireNonNull(this.iterator.next(), "The Stream's Iterator.next() returned a null value");
        }

        @Override
        public boolean isEmpty() {
            Iterator<T> it = this.iterator;
            if (it != null) {
                if (!this.once || it.hasNext()) {
                    return false;
                }
                this.clear();
            }
            return true;
        }

        @Override
        public void clear() {
            this.iterator = null;
            AutoCloseable c15 = this.closeable;
            this.closeable = null;
            if (c15 != null) {
                FlowableFromStream.closeSafely(c15);
            }
        }
    }
}

